/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.compositeindex.datacube.startree.utils;

import java.io.IOException;
import org.apache.lucene.util.LongValues;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.index.compositeindex.datacube.startree.utils.iterator.SortedNumericStarTreeValuesIterator;
import org.opensearch.index.compositeindex.datacube.startree.utils.iterator.SortedSetStarTreeValuesIterator;
import org.opensearch.index.compositeindex.datacube.startree.utils.iterator.StarTreeValuesIterator;

@ExperimentalApi
public class SequentialDocValuesIterator {
    private final StarTreeValuesIterator starTreeValuesIterator;
    private int entryId = -1;

    public SequentialDocValuesIterator(StarTreeValuesIterator starTreeValuesIterator) {
        this.starTreeValuesIterator = starTreeValuesIterator;
    }

    public int getEntryId() {
        return this.entryId;
    }

    private void setEntryId(int entryId) {
        this.entryId = entryId;
    }

    public int nextEntry(int currentEntryId) throws IOException {
        if (this.entryId >= currentEntryId) {
            return this.entryId;
        }
        this.setEntryId(this.starTreeValuesIterator.nextEntry());
        return this.entryId;
    }

    public Long value(int currentEntryId) throws IOException {
        if (this.starTreeValuesIterator instanceof SortedNumericStarTreeValuesIterator) {
            if (currentEntryId < 0) {
                throw new IllegalStateException("invalid entry id to fetch the next value");
            }
            if (currentEntryId == Integer.MAX_VALUE) {
                throw new IllegalStateException("StarTreeValuesIterator is already exhausted");
            }
            if (this.entryId == Integer.MAX_VALUE || this.entryId != currentEntryId) {
                return null;
            }
            return ((SortedNumericStarTreeValuesIterator)this.starTreeValuesIterator).nextValue();
        }
        if (this.starTreeValuesIterator instanceof SortedSetStarTreeValuesIterator) {
            if (currentEntryId < 0) {
                throw new IllegalStateException("invalid entry id to fetch the next value");
            }
            if (currentEntryId == Integer.MAX_VALUE) {
                throw new IllegalStateException("StarTreeValuesIterator is already exhausted");
            }
            if (this.entryId == Integer.MAX_VALUE || this.entryId != currentEntryId) {
                return null;
            }
            return ((SortedSetStarTreeValuesIterator)this.starTreeValuesIterator).nextOrd();
        }
        throw new IllegalStateException("Unsupported Iterator requested for SequentialDocValuesIterator");
    }

    public Long value(int currentEntryId, LongValues globalOrdinalLongValues) throws IOException {
        if (this.starTreeValuesIterator instanceof SortedNumericStarTreeValuesIterator) {
            return this.value(currentEntryId);
        }
        if (this.starTreeValuesIterator instanceof SortedSetStarTreeValuesIterator) {
            assert (globalOrdinalLongValues != null);
            Long val = this.value(currentEntryId);
            if (val != null) {
                val = globalOrdinalLongValues.get(val.longValue());
            }
            return val;
        }
        throw new IllegalStateException("Unsupported Iterator requested for SequentialDocValuesIterator");
    }
}

