/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.nested;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.opensearch.core.common.ParsingException;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.mapper.ObjectMapper;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.search.aggregations.AbstractAggregationBuilder;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.AggregationExecutionException;
import org.opensearch.search.aggregations.AggregatorFactories;
import org.opensearch.search.aggregations.AggregatorFactory;
import org.opensearch.search.aggregations.bucket.nested.NestedAggregator;
import org.opensearch.search.aggregations.bucket.nested.NestedAggregatorFactory;

public class NestedAggregationBuilder
extends AbstractAggregationBuilder<NestedAggregationBuilder> {
    public static final String NAME = "nested";
    private final String path;

    public NestedAggregationBuilder(String name, String path) {
        super(name);
        if (path == null) {
            throw new IllegalArgumentException("[path] must not be null: [" + name + "]");
        }
        this.path = path;
    }

    protected NestedAggregationBuilder(NestedAggregationBuilder clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        super(clone, factoriesBuilder, metadata);
        this.path = clone.path;
    }

    @Override
    protected AggregationBuilder shallowCopy(AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        return new NestedAggregationBuilder(this, factoriesBuilder, metadata);
    }

    public NestedAggregationBuilder(StreamInput in) throws IOException {
        super(in);
        this.path = in.readString();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.path);
    }

    public String path() {
        return this.path;
    }

    @Override
    public AggregationBuilder.BucketCardinality bucketCardinality() {
        return AggregationBuilder.BucketCardinality.ONE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected AggregatorFactory doBuild(QueryShardContext queryShardContext, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        ObjectMapper childObjectMapper = queryShardContext.getObjectMapper(this.path);
        if (childObjectMapper == null) {
            return new NestedAggregatorFactory(this.name, null, null, queryShardContext, parent, subFactoriesBuilder, this.metadata);
        }
        if (!childObjectMapper.nested().isNested()) {
            throw new AggregationExecutionException("[nested] nested path [" + this.path + "] is not nested");
        }
        try {
            ObjectMapper parentObjectMapper = queryShardContext.nestedScope().nextLevel(childObjectMapper);
            NestedAggregatorFactory nestedAggregatorFactory = new NestedAggregatorFactory(this.name, parentObjectMapper, childObjectMapper, queryShardContext, parent, subFactoriesBuilder, this.metadata);
            return nestedAggregatorFactory;
        }
        finally {
            queryShardContext.nestedScope().previousLevel();
        }
    }

    @Override
    protected XContentBuilder internalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(NestedAggregator.PATH_FIELD.getPreferredName(), this.path);
        builder.endObject();
        return builder;
    }

    public static NestedAggregationBuilder parse(String aggregationName, XContentParser parser) throws IOException {
        XContentParser.Token token;
        String path = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.VALUE_STRING) {
                if (NestedAggregator.PATH_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    path = parser.text();
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "Unknown key for a " + String.valueOf(token) + " in [" + aggregationName + "]: [" + currentFieldName + "].", new Object[0]);
            }
            throw new ParsingException(parser.getTokenLocation(), "Unexpected token " + String.valueOf(token) + " in [" + aggregationName + "].", new Object[0]);
        }
        if (path == null) {
            throw new ParsingException(parser.getTokenLocation(), "Missing [path] field for nested aggregation [" + aggregationName + "]", new Object[0]);
        }
        return new NestedAggregationBuilder(aggregationName, path);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.path);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        NestedAggregationBuilder other = (NestedAggregationBuilder)obj;
        return Objects.equals(this.path, other.path);
    }

    @Override
    public String getType() {
        return NAME;
    }
}

