/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg.sig;

import org.bouncycastle.bcpg.SignatureSubpacket;

public class Features
extends SignatureSubpacket {
    public static final byte FEATURE_MODIFICATION_DETECTION = 1;
    public static final byte FEATURE_AEAD_ENCRYPTED_DATA = 2;
    public static final byte FEATURE_VERSION_5_PUBLIC_KEY = 4;
    public static final byte FEATURE_SEIPD_V2 = 8;

    private static final byte[] featureToByteArray(byte feature) {
        byte[] data = new byte[]{feature};
        return data;
    }

    public Features(boolean critical, boolean isLongLength, byte[] data) {
        super(30, critical, isLongLength, data);
    }

    public Features(boolean critical, byte features) {
        super(30, critical, false, Features.featureToByteArray(features));
    }

    public Features(boolean critical, int features) {
        super(30, critical, false, Features.featureToByteArray((byte)features));
    }

    public byte getFeatures() {
        return this.data[0];
    }

    public boolean supportsModificationDetection() {
        return this.supportsFeature((byte)1);
    }

    public boolean supportsSEIPDv2() {
        return this.supportsFeature((byte)8);
    }

    public boolean supportsFeature(byte feature) {
        return (this.data[0] & feature) != 0;
    }
}

