/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial3d.geom;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.lucene.spatial3d.geom.PlanetModel;
import org.apache.lucene.spatial3d.geom.SerializableObject;
import org.apache.lucene.spatial3d.geom.Tools;
import org.apache.lucene.spatial3d.geom.Vector;

public class GeoPoint
extends Vector
implements SerializableObject {
    protected volatile double magnitude = Double.NEGATIVE_INFINITY;
    protected volatile double latitude = Double.NEGATIVE_INFINITY;
    protected volatile double longitude = Double.NEGATIVE_INFINITY;

    public GeoPoint(PlanetModel planetModel, double sinLat, double sinLon, double cosLat, double cosLon, double lat, double lon) {
        this(GeoPoint.computeDesiredEllipsoidMagnitude(planetModel, cosLat * cosLon, cosLat * sinLon, sinLat), cosLat * cosLon, cosLat * sinLon, sinLat, lat, lon);
    }

    public GeoPoint(PlanetModel planetModel, double sinLat, double sinLon, double cosLat, double cosLon) {
        this(GeoPoint.computeDesiredEllipsoidMagnitude(planetModel, cosLat * cosLon, cosLat * sinLon, sinLat), cosLat * cosLon, cosLat * sinLon, sinLat);
    }

    public GeoPoint(PlanetModel planetModel, double lat, double lon) {
        this(planetModel, Math.sin(lat), Math.sin(lon), Math.cos(lat), Math.cos(lon), lat, lon);
    }

    public GeoPoint(PlanetModel planetModel, InputStream inputStream) throws IOException {
        this(inputStream);
    }

    public GeoPoint(InputStream inputStream) throws IOException {
        this(SerializableObject.readDouble(inputStream), SerializableObject.readDouble(inputStream), SerializableObject.readDouble(inputStream), SerializableObject.readDouble(inputStream), SerializableObject.readDouble(inputStream));
    }

    public GeoPoint(double lat, double lon, double x, double y, double z) {
        super(x, y, z);
        this.latitude = lat;
        this.longitude = lon;
    }

    public GeoPoint(double magnitude, double x, double y, double z, double lat, double lon) {
        super(x * magnitude, y * magnitude, z * magnitude);
        this.magnitude = magnitude;
        if (lat > 1.5707963267948966 || lat < -1.5707963267948966) {
            throw new IllegalArgumentException("Latitude " + lat + " is out of range: must range from -Math.PI/2 to Math.PI/2");
        }
        if (lon < -Math.PI || lon > Math.PI) {
            throw new IllegalArgumentException("Longitude " + lon + " is out of range: must range from -Math.PI to Math.PI");
        }
        this.latitude = lat;
        this.longitude = lon;
    }

    public GeoPoint(double magnitude, double x, double y, double z) {
        super(x * magnitude, y * magnitude, z * magnitude);
        this.magnitude = magnitude;
    }

    public GeoPoint(double x, double y, double z) {
        super(x, y, z);
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        SerializableObject.writeDouble(outputStream, this.getLatitude());
        SerializableObject.writeDouble(outputStream, this.getLongitude());
        SerializableObject.writeDouble(outputStream, this.x);
        SerializableObject.writeDouble(outputStream, this.y);
        SerializableObject.writeDouble(outputStream, this.z);
    }

    public double arcDistance(Vector v) {
        return Tools.safeAcos(this.dotProduct(v) / (this.magnitude() * v.magnitude()));
    }

    public double arcDistance(double x, double y, double z) {
        return Tools.safeAcos(this.dotProduct(x, y, z) / (this.magnitude() * Vector.magnitude(x, y, z)));
    }

    public double getLatitude() {
        double lat = this.latitude;
        if (lat == Double.NEGATIVE_INFINITY) {
            this.latitude = lat = Math.asin(this.z / this.magnitude());
        }
        return lat;
    }

    public double getLongitude() {
        double lon = this.longitude;
        if (lon == Double.NEGATIVE_INFINITY) {
            if (Math.abs(this.x) < 1.0E-12 && Math.abs(this.y) < 1.0E-12) {
                lon = 0.0;
                this.longitude = 0.0;
            } else {
                this.longitude = lon = Math.atan2(this.y, this.x);
            }
        }
        return lon;
    }

    @Override
    public double magnitude() {
        double mag = this.magnitude;
        if (mag == Double.NEGATIVE_INFINITY) {
            this.magnitude = mag = super.magnitude();
        }
        return mag;
    }

    public boolean isIdentical(GeoPoint p) {
        return this.isIdentical(p.x, p.y, p.z);
    }

    public boolean isIdentical(double x, double y, double z) {
        return Math.abs(this.x - x) < 1.0E-12 && Math.abs(this.y - y) < 1.0E-12 && Math.abs(this.z - z) < 1.0E-12;
    }

    @Override
    public String toString() {
        if (this.longitude == Double.NEGATIVE_INFINITY) {
            return super.toString();
        }
        return "[lat=" + this.getLatitude() + ", lon=" + this.getLongitude() + "(" + super.toString() + ")]";
    }
}

