/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rule.action;

import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.support.clustermanager.AcknowledgedResponse;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.rule.RulePersistenceService;
import org.opensearch.rule.RulePersistenceServiceRegistry;
import org.opensearch.rule.action.DeleteRuleRequest;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class TransportDeleteRuleAction
extends HandledTransportAction<DeleteRuleRequest, AcknowledgedResponse> {
    private final RulePersistenceServiceRegistry rulePersistenceServiceRegistry;

    @Inject
    public TransportDeleteRuleAction(TransportService transportService, ActionFilters actionFilters, RulePersistenceServiceRegistry rulePersistenceServiceRegistry) {
        super("cluster:admin/opensearch/rule/_delete", transportService, actionFilters, DeleteRuleRequest::new);
        this.rulePersistenceServiceRegistry = rulePersistenceServiceRegistry;
    }

    protected void doExecute(Task task, DeleteRuleRequest request, ActionListener<AcknowledgedResponse> listener) {
        RulePersistenceService rulePersistenceService = this.rulePersistenceServiceRegistry.getRulePersistenceService(request.getFeatureType());
        rulePersistenceService.deleteRule(request, listener);
    }
}

