/*
 * Decompiled with CFR 0.152.
 */
package morfologik.stemming;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.Arrays;
import morfologik.stemming.UnmappableInputException;

public final class BufferUtils {
    private BufferUtils() {
    }

    public static ByteBuffer clearAndEnsureCapacity(ByteBuffer buffer, int elements) {
        if (buffer == null || buffer.capacity() < elements) {
            buffer = ByteBuffer.allocate(elements);
        } else {
            buffer.clear();
        }
        return buffer;
    }

    public static CharBuffer clearAndEnsureCapacity(CharBuffer buffer, int elements) {
        if (buffer == null || buffer.capacity() < elements) {
            buffer = CharBuffer.allocate(elements);
        } else {
            buffer.clear();
        }
        return buffer;
    }

    public static String toString(ByteBuffer buffer, Charset charset) {
        buffer = buffer.slice();
        byte[] buf = new byte[buffer.remaining()];
        buffer.get(buf);
        return new String(buf, charset);
    }

    public static String toString(CharBuffer buffer) {
        buffer = buffer.slice();
        char[] buf = new char[buffer.remaining()];
        buffer.get(buf);
        return new String(buf);
    }

    public static byte[] toArray(ByteBuffer buffer) {
        byte[] dst = new byte[buffer.remaining()];
        buffer.mark();
        buffer.get(dst);
        buffer.reset();
        return dst;
    }

    static int sharedPrefixLength(ByteBuffer a, int aStart, ByteBuffer b, int bStart) {
        int i;
        int max = Math.min(a.remaining() - aStart, b.remaining() - bStart);
        aStart += a.position();
        bStart += b.position();
        for (i = 0; i < max && a.get(aStart++) == b.get(bStart++); ++i) {
        }
        return i;
    }

    static int sharedPrefixLength(ByteBuffer a, ByteBuffer b) {
        return BufferUtils.sharedPrefixLength(a, 0, b, 0);
    }

    public static CharBuffer bytesToChars(CharsetDecoder decoder, ByteBuffer bytes, CharBuffer chars) {
        assert (decoder.malformedInputAction() == CodingErrorAction.REPORT);
        chars = BufferUtils.clearAndEnsureCapacity(chars, (int)((float)bytes.remaining() * decoder.maxCharsPerByte()));
        bytes.mark();
        decoder.reset();
        CoderResult cr = decoder.decode(bytes, chars, true);
        if (cr.isError()) {
            bytes.reset();
            try {
                cr.throwException();
            }
            catch (CharacterCodingException e) {
                throw new RuntimeException("Input cannot be mapped to bytes using encoding " + decoder.charset().name() + ": " + Arrays.toString(BufferUtils.toArray(bytes)), e);
            }
        }
        assert (cr.isUnderflow());
        cr = decoder.flush(chars);
        assert (cr.isUnderflow());
        chars.flip();
        bytes.reset();
        return chars;
    }

    public static ByteBuffer charsToBytes(CharsetEncoder encoder, CharBuffer chars, ByteBuffer bytes) throws UnmappableInputException {
        assert (encoder.malformedInputAction() == CodingErrorAction.REPORT);
        bytes = BufferUtils.clearAndEnsureCapacity(bytes, (int)((float)chars.remaining() * encoder.maxBytesPerChar()));
        chars.mark();
        encoder.reset();
        CoderResult cr = encoder.encode(chars, bytes, true);
        if (cr.isError()) {
            chars.reset();
            try {
                cr.throwException();
            }
            catch (CharacterCodingException e) {
                throw new UnmappableInputException("Input cannot be mapped to characters using encoding " + encoder.charset().name() + ": " + Arrays.toString(BufferUtils.toArray(bytes)), e);
            }
        }
        assert (cr.isUnderflow());
        cr = encoder.flush(bytes);
        assert (cr.isUnderflow());
        bytes.flip();
        chars.reset();
        return bytes;
    }
}

