/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.rest;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.action.RestResponseListener;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.timeseries.util.RestHandlerUtils;
import org.opensearch.transport.client.node.NodeClient;
import org.owasp.encoder.Encode;

public abstract class AbstractSearchAction<T extends ToXContentObject>
extends BaseRestHandler {
    protected final String index;
    protected final Class<T> clazz;
    protected final List<String> urlPaths;
    protected final List<Pair<String, String>> deprecatedPaths;
    protected final ActionType<SearchResponse> actionType;
    protected final Supplier<Boolean> enabledSupplier;
    protected final String disabledMsg;
    private final Logger logger = LogManager.getLogger(AbstractSearchAction.class);

    public AbstractSearchAction(List<String> urlPaths, List<Pair<String, String>> deprecatedPaths, String index, Class<T> clazz, ActionType<SearchResponse> actionType, Supplier<Boolean> adEnabledSupplier, String disabledMsg) {
        this.index = index;
        this.clazz = clazz;
        this.urlPaths = urlPaths;
        this.deprecatedPaths = deprecatedPaths;
        this.actionType = actionType;
        this.enabledSupplier = adEnabledSupplier;
        this.disabledMsg = disabledMsg;
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        if (!this.enabledSupplier.get().booleanValue()) {
            throw new IllegalStateException(this.disabledMsg);
        }
        try {
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
            searchSourceBuilder.parseXContent(request.contentOrSourceParamParser());
            searchSourceBuilder.fetchSource(RestHandlerUtils.getSourceContext(request, searchSourceBuilder));
            searchSourceBuilder.seqNoAndPrimaryTerm(Boolean.valueOf(true)).version(Boolean.valueOf(true));
            SearchRequest searchRequest = new SearchRequest().source(searchSourceBuilder).indices(new String[]{this.index});
            return channel -> client.execute(this.actionType, (ActionRequest)searchRequest, this.search((RestChannel)channel));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(Encode.forHtml((String)e.getMessage()));
        }
    }

    protected void onFailure(RestChannel channel, Exception e) {
        try {
            channel.sendResponse((RestResponse)new BytesRestResponse(channel, e));
        }
        catch (Exception exception) {
            this.logger.error("Failed to send back failure response for search AD result", (Throwable)exception);
        }
    }

    protected RestResponseListener<SearchResponse> search(RestChannel channel) {
        return new RestResponseListener<SearchResponse>(this, channel){

            public RestResponse buildResponse(SearchResponse response) throws Exception {
                if (response.isTimedOut()) {
                    return new BytesRestResponse(RestStatus.REQUEST_TIMEOUT, response.toString());
                }
                return new BytesRestResponse(RestStatus.OK, response.toXContent(this.channel.newBuilder(), ToXContent.EMPTY_PARAMS));
            }
        };
    }

    public List<RestHandler.Route> routes() {
        ArrayList<RestHandler.Route> routes = new ArrayList<RestHandler.Route>();
        for (String path : this.urlPaths) {
            routes.add(new RestHandler.Route(RestRequest.Method.POST, path));
            routes.add(new RestHandler.Route(RestRequest.Method.GET, path));
        }
        return routes;
    }

    public List<RestHandler.ReplacedRoute> replacedRoutes() {
        ArrayList<RestHandler.ReplacedRoute> replacedRoutes = new ArrayList<RestHandler.ReplacedRoute>();
        for (Pair<String, String> deprecatedPath : this.deprecatedPaths) {
            replacedRoutes.add(new RestHandler.ReplacedRoute(RestRequest.Method.POST, (String)deprecatedPath.getKey(), RestRequest.Method.POST, (String)deprecatedPath.getValue()));
            replacedRoutes.add(new RestHandler.ReplacedRoute(RestRequest.Method.GET, (String)deprecatedPath.getKey(), RestRequest.Method.GET, (String)deprecatedPath.getValue()));
        }
        return replacedRoutes;
    }
}

