/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.transport;

import java.io.IOException;
import java.util.Locale;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ValidateActions;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;

public class SingleStreamResultRequest
extends ActionRequest
implements ToXContentObject {
    private final String configId;
    private final String modelId;
    private final long startMillis;
    private final long endMillis;
    private final double[] datapoint;
    private final String taskId;

    public SingleStreamResultRequest(String configId, String modelId, long start, long end, double[] datapoint, String taskId) {
        this.configId = configId;
        this.modelId = modelId;
        this.startMillis = start;
        this.endMillis = end;
        this.datapoint = datapoint;
        this.taskId = taskId;
    }

    public SingleStreamResultRequest(StreamInput in) throws IOException {
        super(in);
        this.configId = in.readString();
        this.modelId = in.readString();
        this.startMillis = in.readLong();
        this.endMillis = in.readLong();
        this.datapoint = in.readDoubleArray();
        this.taskId = in.readOptionalString();
    }

    public String getConfigId() {
        return this.configId;
    }

    public String getModelId() {
        return this.modelId;
    }

    public long getStart() {
        return this.startMillis;
    }

    public long getEnd() {
        return this.endMillis;
    }

    public double[] getDataPoint() {
        return this.datapoint;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.configId);
        out.writeString(this.modelId);
        out.writeLong(this.startMillis);
        out.writeLong(this.endMillis);
        out.writeDoubleArray(this.datapoint);
        out.writeOptionalString(this.taskId);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("config_id", this.configId);
        builder.field("model_id", this.modelId);
        builder.field("start", this.startMillis);
        builder.field("end", this.endMillis);
        builder.array("value_list", this.datapoint);
        builder.field("run_once", this.taskId);
        builder.endObject();
        return builder;
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (Strings.isEmpty((CharSequence)this.configId)) {
            validationException = ValidateActions.addValidationError((String)"config ID is missing", validationException);
        }
        if (Strings.isEmpty((CharSequence)this.modelId)) {
            validationException = ValidateActions.addValidationError((String)"model ID is missing", (ActionRequestValidationException)validationException);
        }
        if (this.startMillis <= 0L || this.endMillis <= 0L || this.startMillis > this.endMillis) {
            validationException = ValidateActions.addValidationError((String)String.format(Locale.ROOT, "%s: start %d, end %d", "timestamp is invalid", this.startMillis, this.endMillis), (ActionRequestValidationException)validationException);
        }
        return validationException;
    }
}

