/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import React from 'react';
import PropTypes from "prop-types";
import { keysOf } from '../common';
import classNames from 'classnames';
var typeToClassNameMap = {
  regular: 'ouiCommentEvent--regular',
  update: 'ouiCommentEvent--update'
};
export var TYPES = keysOf(typeToClassNameMap);
export var OuiCommentEvent = function OuiCommentEvent(_ref) {
  var children = _ref.children,
    className = _ref.className,
    username = _ref.username,
    timestamp = _ref.timestamp,
    _ref$type = _ref.type,
    type = _ref$type === void 0 ? 'regular' : _ref$type,
    event = _ref.event,
    actions = _ref.actions;
  var classes = classNames('ouiCommentEvent', typeToClassNameMap[type], className);
  var isFigure = type === 'regular' || type === 'update' && typeof children !== 'undefined';
  var Element = isFigure ? 'figure' : 'div';
  var HeaderElement = isFigure ? 'figcaption' : 'div';
  return /*#__PURE__*/React.createElement(Element, {
    className: classes
  }, /*#__PURE__*/React.createElement(HeaderElement, {
    className: "ouiCommentEvent__header"
  }, /*#__PURE__*/React.createElement("div", {
    className: "ouiCommentEvent__headerData"
  }, /*#__PURE__*/React.createElement("div", {
    className: "ouiCommentEvent__headerUsername"
  }, username), /*#__PURE__*/React.createElement("div", {
    className: "ouiCommentEvent__headerEvent"
  }, event), timestamp ? /*#__PURE__*/React.createElement("div", {
    className: "ouiCommentEvent__headerTimestamp"
  }, /*#__PURE__*/React.createElement("time", null, timestamp)) : undefined), actions ? /*#__PURE__*/React.createElement("div", {
    className: "ouiCommentEvent__headerActions"
  }, actions) : undefined), children ? /*#__PURE__*/React.createElement("div", {
    className: "ouiCommentEvent__body"
  }, children) : undefined);
};

/* OUI -> EUI Aliases: Build-Time */
OuiCommentEvent.propTypes = {
  /**
     * Author of the comment. Display a small icon or avatar with it if needed.
     */
  username: PropTypes.node.isRequired,
  /**
     * Time of occurrence of the event. Its format is set on the consumer's side
     */
  timestamp: PropTypes.node,
  /**
     * Describes the event that took place
     */
  event: PropTypes.node,
  /**
     * Custom actions that the user can perform from the comment's header
     */
  actions: PropTypes.node,
  /**
     * Use "update" when the comment is primarily showing info about actions that the user or the system has performed (e.g. "user1 edited a case").
     */
  type: PropTypes.oneOf(["regular", "update"]),
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string
};
/* OUI -> EUI Aliases: Build-Time */export { EuiCommentEvent } from '../../eui_components/comment_list/comment_event';