function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) { ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) { o = n[r], -1 === t.indexOf(o) && {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) { if ({}.hasOwnProperty.call(r, n)) { if (-1 !== e.indexOf(n)) continue; t[n] = r[n]; } } return t; }
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import React from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { OuiNotificationBadge } from '../badge';
import { OuiLoadingSpinner } from '../loading';
import { OuiInnerText } from '../inner_text';
export var OuiFacetButton = function OuiFacetButton(_ref) {
  var children = _ref.children,
    className = _ref.className,
    icon = _ref.icon,
    _ref$isDisabled = _ref.isDisabled,
    isDisabled = _ref$isDisabled === void 0 ? false : _ref$isDisabled,
    _ref$isLoading = _ref.isLoading,
    isLoading = _ref$isLoading === void 0 ? false : _ref$isLoading,
    _ref$isSelected = _ref.isSelected,
    isSelected = _ref$isSelected === void 0 ? false : _ref$isSelected,
    quantity = _ref.quantity,
    buttonRef = _ref.buttonRef,
    rest = _objectWithoutProperties(_ref, ["children", "className", "icon", "isDisabled", "isLoading", "isSelected", "quantity", "buttonRef"]);
  // If in the loading state, force disabled to true
  isDisabled = isLoading ? true : isDisabled;
  var classes = classNames('ouiFacetButton', {
    'ouiFacetButton--isSelected': isSelected,
    'ouiFacetButton--unSelected': !isSelected
  }, className);

  // Add quantity number if provided or loading indicator
  var buttonQuantity;
  if (isLoading) {
    buttonQuantity = /*#__PURE__*/React.createElement(OuiLoadingSpinner, {
      className: "ouiFacetButton__spinner",
      size: "m"
    });
  } else if (typeof quantity === 'number') {
    buttonQuantity = /*#__PURE__*/React.createElement(OuiNotificationBadge, {
      className: "ouiFacetButton__quantity",
      size: "m",
      color: !isSelected || isDisabled ? 'subdued' : 'accent'
    }, quantity);
  }

  // Add an icon to the button if one exists.
  var buttonIcon;
  if (/*#__PURE__*/React.isValidElement(icon)) {
    buttonIcon = /*#__PURE__*/React.cloneElement(icon, {
      className: classNames(icon.props.className, 'ouiFacetButton__icon')
    });
  }
  return /*#__PURE__*/React.createElement(OuiInnerText, null, function (ref, innerText) {
    return /*#__PURE__*/React.createElement("button", _extends({
      className: classes,
      disabled: isDisabled,
      type: "button",
      ref: buttonRef,
      title: rest['aria-label'] || innerText
    }, rest), /*#__PURE__*/React.createElement("span", {
      className: "ouiFacetButton__content"
    }, buttonIcon, /*#__PURE__*/React.createElement("span", {
      className: "ouiFacetButton__text",
      "data-text": innerText,
      ref: ref
    }, children), buttonQuantity));
  });
};

/* OUI -> EUI Aliases: Build-Time */
OuiFacetButton.propTypes = {
  buttonRef: PropTypes.any,
  /**
     * ReactNode to render as this component's content
     */
  children: PropTypes.node.isRequired,
  /**
     * Any node, but preferably a `OuiIcon` or `OuiAvatar`
     */
  icon: PropTypes.node,
  isDisabled: PropTypes.bool,
  /**
     * Adds/swaps for loading spinner & disables
     */
  isLoading: PropTypes.bool,
  /**
     * Changes visual of button to indicate it's currently selected
     */
  isSelected: PropTypes.bool,
  onClick: PropTypes.func,
  /**
     * Adds a notification indicator for displaying the quantity provided
     */
  quantity: PropTypes.number,
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string
};
/* OUI -> EUI Aliases: Build-Time */export { EuiFacetButton } from '../../eui_components/facet/facet_button';