"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PPLFacet = void 0;
var _ppl_datasource = require("../../adaptors/ppl_datasource");
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
                                                                                                                                                                                                                                                                                                                          * Copyright OpenSearch Contributors
                                                                                                                                                                                                                                                                                                                          * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                          */
class PPLFacet {
  constructor(client) {
    this.client = client;
    _defineProperty(this, "fetch", async (context, request, format, _responseFormat) => {
      const res = {
        success: false,
        data: {}
      };
      try {
        const dataSourceMDSId = request.query.dataSourceMDSId;
        const params = {
          body: {
            query: request.body.query
          }
        };
        if (request.body.format !== 'jdbc') {
          params.format = request.body.format;
        }
        let queryRes;
        if (dataSourceMDSId) {
          const mdsClient = context.dataSource.opensearch.legacy.getClient(dataSourceMDSId);
          queryRes = await mdsClient.callAPI(format, params);
        } else {
          queryRes = await this.client.asScoped(request).callAsCurrentUser(format, params);
        }
        const pplDataSource = new _ppl_datasource.PPLDataSource(queryRes, request.body.format);
        res.success = true;
        res.data = pplDataSource.getDataSource();
      } catch (err) {
        console.error('PPL query fetch err: ', err);
        res.data = err;
      }
      return res;
    });
    _defineProperty(this, "describeQuery", async (context, request) => {
      return this.fetch(context, request, 'ppl.pplQuery', 'json');
    });
    this.client = client;
  }
}
exports.PPLFacet = PPLFacet;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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