/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.NatGateway;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateNatGatewayResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, CreateNatGatewayResponse> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateNatGatewayResponse.getter(CreateNatGatewayResponse::clientToken)).setter(CreateNatGatewayResponse.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").unmarshallLocationName("clientToken").build()}).build();
    private static final SdkField<NatGateway> NAT_GATEWAY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NatGateway").getter(CreateNatGatewayResponse.getter(CreateNatGatewayResponse::natGateway)).setter(CreateNatGatewayResponse.setter(Builder::natGateway)).constructor(NatGateway::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NatGateway").unmarshallLocationName("natGateway").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, NAT_GATEWAY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateNatGatewayResponse.memberNameToFieldInitializer();
    private final String clientToken;
    private final NatGateway natGateway;

    private CreateNatGatewayResponse(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.natGateway = builder.natGateway;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final NatGateway natGateway() {
        return this.natGateway;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.natGateway());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateNatGatewayResponse)) {
            return false;
        }
        CreateNatGatewayResponse other = (CreateNatGatewayResponse)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.natGateway(), other.natGateway());
    }

    public final String toString() {
        return ToString.builder((String)"CreateNatGatewayResponse").add("ClientToken", (Object)this.clientToken()).add("NatGateway", (Object)this.natGateway()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "NatGateway": {
                return Optional.ofNullable(clazz.cast(this.natGateway()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("NatGateway", NAT_GATEWAY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateNatGatewayResponse, T> g) {
        return obj -> g.apply((CreateNatGatewayResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private String clientToken;
        private NatGateway natGateway;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateNatGatewayResponse model) {
            super(model);
            this.clientToken(model.clientToken);
            this.natGateway(model.natGateway);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final NatGateway.Builder getNatGateway() {
            return this.natGateway != null ? this.natGateway.toBuilder() : null;
        }

        public final void setNatGateway(NatGateway.BuilderImpl natGateway) {
            this.natGateway = natGateway != null ? natGateway.build() : null;
        }

        @Override
        public final Builder natGateway(NatGateway natGateway) {
            this.natGateway = natGateway;
            return this;
        }

        @Override
        public CreateNatGatewayResponse build() {
            return new CreateNatGatewayResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateNatGatewayResponse> {
        public Builder clientToken(String var1);

        public Builder natGateway(NatGateway var1);

        default public Builder natGateway(Consumer<NatGateway.Builder> natGateway) {
            return this.natGateway((NatGateway)((NatGateway.Builder)NatGateway.builder().applyMutation(natGateway)).build());
        }
    }
}

