/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.codec.nativeindex.remote;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.knn.index.codec.util.KNNCodecUtil;
import org.opensearch.knn.index.vectorvalues.KNNVectorValues;

class DocIdInputStream
extends InputStream {
    @Generated
    private static final Logger log = LogManager.getLogger(DocIdInputStream.class);
    private final KNNVectorValues<?> knnVectorValues;
    private ByteBuffer currentBuffer;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public DocIdInputStream(KNNVectorValues<?> knnVectorValues) throws IOException {
        this.currentBuffer = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
        this.knnVectorValues = knnVectorValues;
        KNNCodecUtil.initializeVectorValues(this.knnVectorValues);
        this.reloadBuffer();
    }

    @Override
    public int read() throws IOException {
        this.checkClosed();
        if (this.currentBuffer == null) {
            return -1;
        }
        if (!this.currentBuffer.hasRemaining()) {
            this.advanceAndReloadBuffer();
            if (this.currentBuffer == null) {
                return -1;
            }
        }
        return this.currentBuffer.get() & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.checkClosed();
        if (this.currentBuffer == null) {
            return -1;
        }
        int available = this.currentBuffer.remaining();
        if (available <= 0) {
            this.advanceAndReloadBuffer();
            if (this.currentBuffer == null) {
                return -1;
            }
            available = this.currentBuffer.remaining();
        }
        int bytesToRead = Math.min(available, len);
        this.currentBuffer.get(b, off, bytesToRead);
        return bytesToRead;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.currentBuffer = null;
        this.closed.set(true);
    }

    private void checkClosed() throws IOException {
        if (this.closed.get()) {
            throw new IOException("Stream closed");
        }
    }

    private void advanceAndReloadBuffer() throws IOException {
        int docId = this.knnVectorValues.nextDoc();
        if (docId != -1 && docId != Integer.MAX_VALUE) {
            this.reloadBuffer();
        } else {
            this.currentBuffer = null;
        }
    }

    private void reloadBuffer() throws IOException {
        this.currentBuffer.clear();
        this.currentBuffer.putInt(this.knnVectorValues.docId());
        this.currentBuffer.position(0);
    }
}

