/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.processor.normalization.bounds;

import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;

public enum BoundMode {
    APPLY,
    CLIP,
    IGNORE;

    public static final BoundMode DEFAULT;

    public static String getValidValues() {
        return Arrays.stream(BoundMode.values()).map(mode -> mode.name().toLowerCase(Locale.ROOT)).collect(Collectors.joining(", "));
    }

    public static BoundMode fromString(String value) {
        if (Objects.isNull(value) || value.trim().isEmpty()) {
            return DEFAULT;
        }
        try {
            return BoundMode.valueOf(value.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "invalid mode: %s, valid values are: %s", value, BoundMode.getValidValues()));
        }
    }

    public String toString() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    static {
        DEFAULT = APPLY;
    }
}

