/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.query_dsl;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.Script;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.QueryBase;
import org.opensearch.client.opensearch._types.query_dsl.QueryVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class ScriptScoreQuery
extends QueryBase
implements QueryVariant,
ToCopyableBuilder<Builder, ScriptScoreQuery> {
    @Nullable
    private final Float minScore;
    @Nonnull
    private final Query query;
    @Nonnull
    private final Script script;
    public static final JsonpDeserializer<ScriptScoreQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ScriptScoreQuery::setupScriptScoreQueryDeserializer);

    private ScriptScoreQuery(Builder builder) {
        super(builder);
        this.minScore = builder.minScore;
        this.query = ApiTypeHelper.requireNonNull(builder.query, this, "query");
        this.script = ApiTypeHelper.requireNonNull(builder.script, this, "script");
    }

    public static ScriptScoreQuery of(Function<Builder, ObjectBuilder<ScriptScoreQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.ScriptScore;
    }

    @Nullable
    public final Float minScore() {
        return this.minScore;
    }

    @Nonnull
    public final Query query() {
        return this.query;
    }

    @Nonnull
    public final Script script() {
        return this.script;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.minScore != null) {
            generator.writeKey("min_score");
            generator.write((double)this.minScore.floatValue());
        }
        generator.writeKey("query");
        this.query.serialize(generator, mapper);
        generator.writeKey("script");
        this.script.serialize(generator, mapper);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupScriptScoreQueryDeserializer(ObjectDeserializer<Builder> op) {
        ScriptScoreQuery.setupQueryBaseDeserializer(op);
        op.add(Builder::minScore, JsonpDeserializer.floatDeserializer(), "min_score");
        op.add(Builder::query, Query._DESERIALIZER, "query");
        op.add(Builder::script, Script._DESERIALIZER, "script");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.minScore);
        result = 31 * result + this.query.hashCode();
        result = 31 * result + this.script.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScriptScoreQuery other = (ScriptScoreQuery)o;
        return Objects.equals(this.minScore, other.minScore) && this.query.equals(other.query) && this.script.equals(other.script);
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, ScriptScoreQuery> {
        @Nullable
        private Float minScore;
        private Query query;
        private Script script;

        public Builder() {
        }

        private Builder(ScriptScoreQuery o) {
            super(o);
            this.minScore = o.minScore;
            this.query = o.query;
            this.script = o.script;
        }

        private Builder(Builder o) {
            super(o);
            this.minScore = o.minScore;
            this.query = o.query;
            this.script = o.script;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder minScore(@Nullable Float value) {
            this.minScore = value;
            return this;
        }

        @Nonnull
        public final Builder query(Query value) {
            this.query = value;
            return this;
        }

        @Nonnull
        public final Builder query(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.query(fn.apply(new Query.Builder()).build());
        }

        @Nonnull
        public final Builder script(Script value) {
            this.script = value;
            return this;
        }

        @Nonnull
        public final Builder script(Function<Script.Builder, ObjectBuilder<Script>> fn) {
            return this.script(fn.apply(new Script.Builder()).build());
        }

        @Override
        @Nonnull
        public ScriptScoreQuery build() {
            this._checkSingleUse();
            return new ScriptScoreQuery(this);
        }
    }
}

