/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.query_dsl;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.FieldValue;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.QueryBase;
import org.opensearch.client.opensearch._types.query_dsl.QueryVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class TermQuery
extends QueryBase
implements QueryVariant,
ToCopyableBuilder<Builder, TermQuery> {
    @Nullable
    private final Boolean caseInsensitive;
    @Nonnull
    private final String field;
    @Nonnull
    private final FieldValue value;
    public static final JsonpDeserializer<TermQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TermQuery::setupTermQueryDeserializer);

    private TermQuery(Builder builder) {
        super(builder);
        this.caseInsensitive = builder.caseInsensitive;
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.value = ApiTypeHelper.requireNonNull(builder.value, this, "value");
    }

    public static TermQuery of(Function<Builder, ObjectBuilder<TermQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.Term;
    }

    @Nullable
    public final Boolean caseInsensitive() {
        return this.caseInsensitive;
    }

    @Nonnull
    public final String field() {
        return this.field;
    }

    @Nonnull
    public final FieldValue value() {
        return this.value;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject(this.field);
        super.serializeInternal(generator, mapper);
        if (this.caseInsensitive != null) {
            generator.writeKey("case_insensitive");
            generator.write(this.caseInsensitive.booleanValue());
        }
        generator.writeKey("value");
        this.value.serialize(generator, mapper);
        generator.writeEnd();
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupTermQueryDeserializer(ObjectDeserializer<Builder> op) {
        TermQuery.setupQueryBaseDeserializer(op);
        op.add(Builder::caseInsensitive, JsonpDeserializer.booleanDeserializer(), "case_insensitive");
        op.add(Builder::value, FieldValue._DESERIALIZER, "value");
        op.setKey(Builder::field, JsonpDeserializer.stringDeserializer());
        op.shortcutProperty("value");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.caseInsensitive);
        result = 31 * result + this.field.hashCode();
        result = 31 * result + this.value.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TermQuery other = (TermQuery)o;
        return Objects.equals(this.caseInsensitive, other.caseInsensitive) && this.field.equals(other.field) && this.value.equals(other.value);
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, TermQuery> {
        @Nullable
        private Boolean caseInsensitive;
        private String field;
        private FieldValue value;

        public Builder() {
        }

        private Builder(TermQuery o) {
            super(o);
            this.caseInsensitive = o.caseInsensitive;
            this.field = o.field;
            this.value = o.value;
        }

        private Builder(Builder o) {
            super(o);
            this.caseInsensitive = o.caseInsensitive;
            this.field = o.field;
            this.value = o.value;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder caseInsensitive(@Nullable Boolean value) {
            this.caseInsensitive = value;
            return this;
        }

        @Nonnull
        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        @Nonnull
        public final Builder value(FieldValue value) {
            this.value = value;
            return this;
        }

        @Nonnull
        public final Builder value(Function<FieldValue.Builder, ObjectBuilder<FieldValue>> fn) {
            return this.value(fn.apply(new FieldValue.Builder()).build());
        }

        @Override
        @Nonnull
        public TermQuery build() {
            this._checkSingleUse();
            return new TermQuery(this);
        }
    }
}

