/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ingest;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch.ingest.Processor;
import org.opensearch.client.opensearch.ingest.ProcessorBase;
import org.opensearch.client.opensearch.ingest.ProcessorVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class AppendProcessor
extends ProcessorBase
implements ProcessorVariant,
ToCopyableBuilder<Builder, AppendProcessor> {
    @Nullable
    private final Boolean allowDuplicates;
    @Nonnull
    private final String field;
    @Nonnull
    private final List<JsonData> value;
    public static final JsonpDeserializer<AppendProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AppendProcessor::setupAppendProcessorDeserializer);

    private AppendProcessor(Builder builder) {
        super(builder);
        this.allowDuplicates = builder.allowDuplicates;
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.value = ApiTypeHelper.unmodifiableRequired(builder.value, (Object)this, "value");
    }

    public static AppendProcessor of(Function<Builder, ObjectBuilder<AppendProcessor>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Processor.Kind _processorKind() {
        return Processor.Kind.Append;
    }

    @Nullable
    public final Boolean allowDuplicates() {
        return this.allowDuplicates;
    }

    @Nonnull
    public final String field() {
        return this.field;
    }

    @Nonnull
    public final List<JsonData> value() {
        return this.value;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.allowDuplicates != null) {
            generator.writeKey("allow_duplicates");
            generator.write(this.allowDuplicates.booleanValue());
        }
        generator.writeKey("field");
        generator.write(this.field);
        generator.writeKey("value");
        generator.writeStartArray();
        for (JsonData item0 : this.value) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupAppendProcessorDeserializer(ObjectDeserializer<Builder> op) {
        AppendProcessor.setupProcessorBaseDeserializer(op);
        op.add(Builder::allowDuplicates, JsonpDeserializer.booleanDeserializer(), "allow_duplicates");
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::value, JsonpDeserializer.arrayDeserializer(JsonData._DESERIALIZER), "value");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.allowDuplicates);
        result = 31 * result + this.field.hashCode();
        result = 31 * result + this.value.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppendProcessor other = (AppendProcessor)o;
        return Objects.equals(this.allowDuplicates, other.allowDuplicates) && this.field.equals(other.field) && this.value.equals(other.value);
    }

    public static class Builder
    extends ProcessorBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, AppendProcessor> {
        @Nullable
        private Boolean allowDuplicates;
        private String field;
        private List<JsonData> value;

        public Builder() {
        }

        private Builder(AppendProcessor o) {
            super(o);
            this.allowDuplicates = o.allowDuplicates;
            this.field = o.field;
            this.value = Builder._listCopy(o.value);
        }

        private Builder(Builder o) {
            super(o);
            this.allowDuplicates = o.allowDuplicates;
            this.field = o.field;
            this.value = Builder._listCopy(o.value);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder allowDuplicates(@Nullable Boolean value) {
            this.allowDuplicates = value;
            return this;
        }

        @Nonnull
        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        @Nonnull
        public final Builder value(List<JsonData> list) {
            this.value = Builder._listAddAll(this.value, list);
            return this;
        }

        @Nonnull
        public final Builder value(JsonData value, JsonData ... values) {
            this.value = Builder._listAdd(this.value, value, values);
            return this;
        }

        @Override
        @Nonnull
        public AppendProcessor build() {
            this._checkSingleUse();
            return new AppendProcessor(this);
        }
    }
}

