/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.notifications.resthandler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.opensearch.commons.notifications.NotificationsPluginInterface;
import org.opensearch.commons.notifications.action.CreateNotificationConfigRequest;
import org.opensearch.commons.notifications.action.DeleteNotificationConfigRequest;
import org.opensearch.commons.notifications.action.GetNotificationConfigRequest;
import org.opensearch.commons.notifications.action.UpdateNotificationConfigRequest;
import org.opensearch.commons.utils.HelpersKt;
import org.opensearch.commons.utils.XContentHelpersKt;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.notifications.index.ConfigQueryHelper;
import org.opensearch.notifications.metrics.Metrics;
import org.opensearch.notifications.resthandler.PluginBaseHandler;
import org.opensearch.notifications.resthandler.RestResponseToXContentListener;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.search.sort.SortOrder;
import org.opensearch.transport.client.node.NodeClient;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\"\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000fH\u0002J\b\u0010\u0012\u001a\u00020\u000fH\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0014J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0016\u00a8\u0006\u0018"}, d2={"Lorg/opensearch/notifications/resthandler/NotificationConfigRestHandler;", "Lorg/opensearch/notifications/resthandler/PluginBaseHandler;", "()V", "executeDeleteRequest", "Lorg/opensearch/rest/BaseRestHandler$RestChannelConsumer;", "request", "Lorg/opensearch/rest/RestRequest;", "client", "Lorg/opensearch/transport/client/node/NodeClient;", "executeGetRequest", "executePostRequest", "executePutRequest", "executeRequest", "getConfigIdSet", "", "", "configId", "configIdList", "getName", "responseParams", "routes", "", "Lorg/opensearch/rest/RestHandler$Route;", "Companion", "opensearch-notifications"})
@SourceDebugExtension(value={"SMAP\nNotificationConfigRestHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotificationConfigRestHandler.kt\norg/opensearch/notifications/resthandler/NotificationConfigRestHandler\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,279:1\n526#2:280\n511#2,6:281\n125#3:287\n152#3,3:288\n3792#4:291\n4307#4,2:292\n*S KotlinDebug\n*F\n+ 1 NotificationConfigRestHandler.kt\norg/opensearch/notifications/resthandler/NotificationConfigRestHandler\n*L\n215#1:280\n215#1:281,6\n216#1:287\n216#1:288,3\n259#1:291\n259#1:292,2\n*E\n"})
public final class NotificationConfigRestHandler
extends PluginBaseHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Lazy<Logger> log$delegate = HelpersKt.logger(NotificationConfigRestHandler.class);
    @NotNull
    private static final String REQUEST_URL = "/_plugins/_notifications/configs";

    @NotNull
    public String getName() {
        return "notifications_config";
    }

    @NotNull
    public List<RestHandler.Route> routes() {
        Object[] objectArray = new RestHandler.Route[]{new RestHandler.Route(RestRequest.Method.POST, REQUEST_URL), new RestHandler.Route(RestRequest.Method.PUT, "/_plugins/_notifications/configs/{config_id}"), new RestHandler.Route(RestRequest.Method.DELETE, "/_plugins/_notifications/configs/{config_id}"), new RestHandler.Route(RestRequest.Method.DELETE, REQUEST_URL), new RestHandler.Route(RestRequest.Method.GET, "/_plugins/_notifications/configs/{config_id}"), new RestHandler.Route(RestRequest.Method.GET, REQUEST_URL)};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    protected Set<String> responseParams() {
        Object[] objectArray = new String[]{"config_id", "config_id_list", "sort_field", "sort_order", "from_index", "max_items"};
        return SetsKt.setOf((Object[])objectArray);
    }

    @Override
    @NotNull
    protected BaseRestHandler.RestChannelConsumer executeRequest(@NotNull RestRequest request, @NotNull NodeClient client) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        RestRequest.Method method = request.method();
        return switch (method == null ? -1 : WhenMappings.$EnumSwitchMapping$0[method.ordinal()]) {
            case 1 -> this.executePostRequest(request, client);
            case 2 -> this.executePutRequest(request, client);
            case 3 -> this.executeDeleteRequest(request, client);
            case 4 -> this.executeGetRequest(request, client);
            default -> arg_0 -> NotificationConfigRestHandler.executeRequest$lambda$0(request, arg_0);
        };
    }

    private final BaseRestHandler.RestChannelConsumer executePutRequest(RestRequest request, NodeClient client) {
        return arg_0 -> NotificationConfigRestHandler.executePutRequest$lambda$1(client, request, arg_0);
    }

    private final BaseRestHandler.RestChannelConsumer executePostRequest(RestRequest request, NodeClient client) {
        return arg_0 -> NotificationConfigRestHandler.executePostRequest$lambda$2(client, request, arg_0);
    }

    /*
     * WARNING - void declaration
     */
    private final BaseRestHandler.RestChannelConsumer executeGetRequest(RestRequest request, NodeClient client) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Map.Entry it;
        void $this$filterTo$iv$iv;
        Map $this$filter$iv;
        Metrics.NOTIFICATIONS_CONFIG_INFO_TOTAL.getCounter().increment();
        Metrics.NOTIFICATIONS_CONFIG_INFO_INTERVAL_COUNT.getCounter().increment();
        String configId = request.param("config_id");
        String configIdList = request.param("config_id_list");
        String sortField = request.param("sort_field");
        String sortOrderString = request.param("sort_order");
        SortOrder sortOrder = sortOrderString == null ? null : SortOrder.fromString((String)sortOrderString);
        Object object = request.param("from_index");
        int fromIndex = object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : 0;
        Object object2 = request.param("max_items");
        int maxItems = object2 != null && (object2 = StringsKt.toIntOrNull((String)object2)) != null ? (Integer)object2 : 1000;
        Map map = request.params();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"params(...)");
        Map map2 = map;
        boolean $i$f$filter = false;
        void var13_12 = $this$filter$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!ConfigQueryHelper.INSTANCE.getFILTER_PARAMS().contains(it.getKey())) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        $this$filter$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
            it = item$iv$iv;
            Object object3 = destination$iv$iv;
            boolean bl = false;
            object3.add(new Pair(it.getKey(), (Object)request.param((String)it.getKey())));
        }
        Map filterParams = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        NotificationConfigRestHandler.Companion.getLog().info("notifications:executeGetRequest from:" + fromIndex + ", maxItems:" + maxItems + ", sortField:" + sortField + ", sortOrder=" + sortOrder + ", filters=" + filterParams);
        GetNotificationConfigRequest configRequest = new GetNotificationConfigRequest(this.getConfigIdSet(configId, configIdList), fromIndex, maxItems, sortField, sortOrder, filterParams);
        return arg_0 -> NotificationConfigRestHandler.executeGetRequest$lambda$5(client, configRequest, arg_0);
    }

    private final Set<String> getConfigIdSet(String configId, String configIdList) {
        Set retIds = SetsKt.emptySet();
        if (configId != null) {
            retIds = SetsKt.setOf((Object)configId);
        }
        if (configIdList != null) {
            String[] stringArray = new String[]{","};
            retIds = CollectionsKt.union((Iterable)StringsKt.split$default((CharSequence)configIdList, (String[])stringArray, (boolean)false, (int)0, (int)6, null), (Iterable)retIds);
        }
        return retIds;
    }

    /*
     * WARNING - void declaration
     */
    private final BaseRestHandler.RestChannelConsumer executeDeleteRequest(RestRequest request, NodeClient client) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Metrics.NOTIFICATIONS_CONFIG_DELETE_TOTAL.getCounter().increment();
        Metrics.NOTIFICATIONS_CONFIG_DELETE_INTERVAL_COUNT.getCounter().increment();
        String configId = request.param("config_id");
        String[] stringArray = new String[]{configId};
        String[] stringArray2 = request.paramAsStringArray("config_id_list", stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray2, (String)"paramAsStringArray(...)");
        Object[] objectArray = stringArray2;
        boolean $i$f$filter = false;
        void var7_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            String s = (String)element$iv$iv;
            boolean bl = false;
            CharSequence charSequence = s;
            boolean bl2 = !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence));
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Set configIdSet = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        return arg_0 -> NotificationConfigRestHandler.executeDeleteRequest$lambda$7(configIdSet, client, arg_0);
    }

    private static final void executeRequest$lambda$0(RestRequest $request, RestChannel it) {
        Intrinsics.checkNotNullParameter((Object)$request, (String)"$request");
        it.sendResponse((RestResponse)new BytesRestResponse(RestStatus.METHOD_NOT_ALLOWED, $request.method() + " is not allowed"));
    }

    private static final void executePutRequest$lambda$1(NodeClient $client, RestRequest $request, RestChannel it) {
        Intrinsics.checkNotNullParameter((Object)$client, (String)"$client");
        Intrinsics.checkNotNullParameter((Object)$request, (String)"$request");
        Metrics.NOTIFICATIONS_CONFIG_UPDATE_TOTAL.getCounter().increment();
        Metrics.NOTIFICATIONS_CONFIG_UPDATE_INTERVAL_COUNT.getCounter().increment();
        NotificationsPluginInterface.INSTANCE.updateNotificationConfig($client, UpdateNotificationConfigRequest.Companion.parse(XContentHelpersKt.contentParserNextToken((RestRequest)$request), $request.param("config_id")), (ActionListener)new RestToXContentListener(it));
    }

    private static final void executePostRequest$lambda$2(NodeClient $client, RestRequest $request, RestChannel it) {
        Intrinsics.checkNotNullParameter((Object)$client, (String)"$client");
        Intrinsics.checkNotNullParameter((Object)$request, (String)"$request");
        Metrics.NOTIFICATIONS_CONFIG_CREATE_TOTAL.getCounter().increment();
        Metrics.NOTIFICATIONS_CONFIG_CREATE_INTERVAL_COUNT.getCounter().increment();
        NotificationsPluginInterface.INSTANCE.createNotificationConfig($client, CreateNotificationConfigRequest.Companion.parse$default((CreateNotificationConfigRequest.Companion)CreateNotificationConfigRequest.Companion, (XContentParser)XContentHelpersKt.contentParserNextToken((RestRequest)$request), null, (int)2, null), (ActionListener)new RestToXContentListener(it));
    }

    private static final void executeGetRequest$lambda$5(NodeClient $client, GetNotificationConfigRequest $configRequest, RestChannel it) {
        Intrinsics.checkNotNullParameter((Object)$client, (String)"$client");
        Intrinsics.checkNotNullParameter((Object)$configRequest, (String)"$configRequest");
        NotificationsPluginInterface.INSTANCE.getNotificationConfig($client, $configRequest, (ActionListener)new RestToXContentListener(it));
    }

    private static final void executeDeleteRequest$lambda$7(Set $configIdSet, NodeClient $client, RestChannel it) {
        Intrinsics.checkNotNullParameter((Object)$configIdSet, (String)"$configIdSet");
        Intrinsics.checkNotNullParameter((Object)$client, (String)"$client");
        if ($configIdSet.isEmpty()) {
            it.sendResponse((RestResponse)new BytesRestResponse(RestStatus.BAD_REQUEST, "either config_id or config_id_list is required"));
        } else {
            DeleteNotificationConfigRequest deleteNotificationConfigRequest = new DeleteNotificationConfigRequest($configIdSet);
            Intrinsics.checkNotNull((Object)it);
            NotificationsPluginInterface.INSTANCE.deleteNotificationConfig($client, deleteNotificationConfigRequest, (ActionListener)new RestResponseToXContentListener(it));
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Lorg/opensearch/notifications/resthandler/NotificationConfigRestHandler$Companion;", "", "()V", "REQUEST_URL", "", "log", "Lorg/apache/logging/log4j/Logger;", "getLog", "()Lorg/apache/logging/log4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "opensearch-notifications"})
    public static final class Companion {
        private Companion() {
        }

        private final Logger getLog() {
            Lazy lazy = log$delegate;
            return (Logger)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RestRequest.Method.values().length];
            try {
                nArray[RestRequest.Method.POST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RestRequest.Method.PUT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RestRequest.Method.DELETE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RestRequest.Method.GET.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

