/*
 * Decompiled with CFR 0.152.
 */
package com.azure.xml.implementation.aalto.out;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

final class NsBinder {
    static final int DEFAULT_ARRAY_SIZE = 32;
    final int _scopeStart;
    String[] _nsStrings;
    int _scopeEnd;

    private NsBinder(int scopeStart, String[] strs) {
        this._scopeStart = this._scopeEnd = scopeStart;
        this._nsStrings = strs;
    }

    public static NsBinder createEmpty() {
        String[] strs = new String[32];
        strs[0] = "xml";
        strs[1] = "http://www.w3.org/XML/1998/namespace";
        strs[2] = "xmlns";
        strs[3] = "http://www.w3.org/2000/xmlns/";
        return new NsBinder(4, strs);
    }

    public NsBinder createChild() {
        return new NsBinder(this._scopeEnd, this._nsStrings);
    }

    public String findUriByPrefix(String prefix) {
        String[] strs = this._nsStrings;
        int phash = prefix.hashCode();
        for (int ix = this._scopeEnd - 2; ix >= 0; ix -= 2) {
            String thisP = strs[ix];
            if (!Objects.equals(thisP, prefix) && (thisP.hashCode() != phash || !thisP.equals(prefix))) continue;
            return strs[ix + 1];
        }
        return null;
    }

    public String findPrefixByUri(String uri) {
        String[] strs = this._nsStrings;
        int uhash = uri.hashCode();
        block0: for (int ix = this._scopeEnd - 1; ix > 0; ix -= 2) {
            String thisU = strs[ix];
            if (!Objects.equals(thisU, uri) && (thisU.hashCode() != uhash || !thisU.equals(uri))) continue;
            String prefix = strs[ix - 1];
            if (ix < this._scopeStart) {
                int phash = prefix.hashCode();
                int end = this._scopeEnd;
                for (int j = ix - 1; j < end; j += 2) {
                    String thisP = strs[ix];
                    if (Objects.equals(thisP, prefix) || thisP.hashCode() == phash && thisP.equals(prefix)) continue block0;
                }
            }
            return prefix;
        }
        return null;
    }

    public List<String> getPrefixesBoundToUri(String uri, List<String> l) {
        String[] strs = this._nsStrings;
        int uhash = uri.hashCode();
        block0: for (int ix = this._scopeEnd - 1; ix > 0; ix -= 2) {
            String thisU = strs[ix];
            if (!Objects.equals(thisU, uri) && (thisU.hashCode() != uhash || !thisU.equals(uri))) continue;
            String prefix = strs[ix - 1];
            if (ix < this._scopeStart) {
                int phash = prefix.hashCode();
                int end = this._scopeEnd;
                for (int j = ix - 1; j < end; j += 2) {
                    String thisP = strs[ix];
                    if (Objects.equals(thisP, prefix) || thisP.hashCode() == phash && thisP.equals(prefix)) continue block0;
                }
            }
            if (l == null) {
                l = new ArrayList<String>();
            }
            l.add(prefix);
        }
        return l;
    }

    public int size() {
        return this._scopeEnd >> 1;
    }

    public int localSize() {
        return this._scopeEnd - this._scopeStart >> 1;
    }

    void addMapping(String prefix, String uri) {
        String[] strs = this._nsStrings;
        int phash = prefix.hashCode();
        int end = this._scopeEnd;
        for (int ix = this._scopeStart; ix < end; ix += 2) {
            String thisP = strs[ix];
            if (!Objects.equals(thisP, prefix) && (thisP.hashCode() != phash || !thisP.equals(prefix))) continue;
            strs[ix + 1] = uri;
            return;
        }
        if (this._scopeEnd >= strs.length) {
            this._nsStrings = strs = Arrays.copyOf(strs, strs.length << 1);
        }
        strs[this._scopeEnd++] = prefix;
        strs[this._scopeEnd++] = uri;
    }

    public String toString() {
        return "[" + this.getClass() + "; " + this.size() + " entries; of which " + this.localSize() + " local]";
    }
}

