/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.crt.internal.request;

import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.reactivestreams.Subscriber;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.crt.http.HttpRequestBodyStream;
import software.amazon.awssdk.http.async.SdkHttpContentPublisher;
import software.amazon.awssdk.utils.async.ByteBufferStoringSubscriber;

@SdkInternalApi
final class CrtRequestBodyAdapter
implements HttpRequestBodyStream {
    private final SdkHttpContentPublisher requestPublisher;
    private final ByteBufferStoringSubscriber requestBodySubscriber;
    private final AtomicBoolean subscribed = new AtomicBoolean(false);

    CrtRequestBodyAdapter(SdkHttpContentPublisher requestPublisher, long readLimit) {
        this.requestPublisher = requestPublisher;
        this.requestBodySubscriber = new ByteBufferStoringSubscriber(readLimit);
    }

    public boolean sendRequestBody(ByteBuffer bodyBytesOut) {
        if (this.subscribed.compareAndSet(false, true)) {
            this.requestPublisher.subscribe((Subscriber)this.requestBodySubscriber);
        }
        return this.requestBodySubscriber.transferTo(bodyBytesOut) == ByteBufferStoringSubscriber.TransferResult.END_OF_STREAM;
    }

    public long getLength() {
        return this.requestPublisher.contentLength().orElse(0L);
    }
}

