/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.authtoken.jwt;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.KeyLengthException;
import com.nimbusds.jose.crypto.MACSigner;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.KeyUse;
import com.nimbusds.jose.jwk.OctetSequenceKey;
import com.nimbusds.jwt.SignedJWT;
import java.security.AccessController;
import java.text.ParseException;
import java.util.Base64;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.settings.Settings;
import org.opensearch.security.authtoken.jwt.ExpiringBearerAuthToken;
import org.opensearch.security.authtoken.jwt.claims.JwtClaimsBuilder;
import org.opensearch.security.util.AuthTokenUtils;

public class JwtVendor {
    private static final Logger logger = LogManager.getLogger(JwtVendor.class);
    private final JWK signingKey;
    private final JWSSigner signer;

    public JwtVendor(Settings settings) {
        Tuple<JWK, JWSSigner> tuple = JwtVendor.createJwkFromSettings(settings);
        this.signingKey = (JWK)tuple.v1();
        this.signer = (JWSSigner)tuple.v2();
    }

    static Tuple<JWK, JWSSigner> createJwkFromSettings(Settings settings) {
        OctetSequenceKey key;
        if (!AuthTokenUtils.isKeyNull(settings, "signing_key").booleanValue()) {
            String signingKey = settings.get("signing_key");
            key = new OctetSequenceKey.Builder(Base64.getDecoder().decode(signingKey)).algorithm((Algorithm)JWSAlgorithm.HS512).keyUse(KeyUse.SIGNATURE).build();
        } else {
            Settings jwkSettings = settings.getAsSettings("jwt").getAsSettings("key");
            if (jwkSettings.isEmpty()) {
                throw new OpenSearchException("Settings for signing key is missing. Please specify at least the option signing_key with a shared secret.", new Object[0]);
            }
            String signingKey = jwkSettings.get("k");
            key = new OctetSequenceKey.Builder(Base64.getDecoder().decode(signingKey)).algorithm((Algorithm)JWSAlgorithm.HS512).keyUse(KeyUse.SIGNATURE).build();
        }
        try {
            return new Tuple((Object)key, (Object)new MACSigner(key));
        }
        catch (KeyLengthException kle) {
            throw new OpenSearchException((Throwable)kle);
        }
    }

    public ExpiringBearerAuthToken createJwt(JwtClaimsBuilder claimsBuilder, String subject, Date expiryTime, Long expirySeconds) throws JOSEException, ParseException {
        JWSHeader header = new JWSHeader.Builder(JWSAlgorithm.parse((String)this.signingKey.getAlgorithm().getName())).build();
        SignedJWT signedJwt = AccessController.doPrivileged(() -> new SignedJWT(header, claimsBuilder.build()));
        signedJwt.sign(this.signer);
        if (logger.isDebugEnabled()) {
            logger.debug("Created JWT: " + signedJwt.serialize() + "\n" + String.valueOf(signedJwt.getHeader().toJSONObject()) + "\n" + String.valueOf(signedJwt.getJWTClaimsSet()));
        }
        return new ExpiringBearerAuthToken(signedJwt.serialize(), subject, expiryTime, expirySeconds);
    }
}

