/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.identity;

import java.security.Principal;
import org.opensearch.common.CheckedRunnable;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.identity.NamedPrincipal;
import org.opensearch.identity.PluginSubject;
import org.opensearch.plugins.Plugin;
import org.opensearch.security.user.User;
import org.opensearch.threadpool.ThreadPool;

public class SecurePluginSubject
implements PluginSubject {
    private final ThreadPool threadPool;
    private final NamedPrincipal pluginPrincipal;
    private final User pluginUser;

    public static String getPluginPrincipalName(String canonicalClassName) {
        return "plugin:" + canonicalClassName;
    }

    public SecurePluginSubject(ThreadPool threadPool, Settings settings, Plugin plugin) {
        this.threadPool = threadPool;
        String principal = SecurePluginSubject.getPluginPrincipalName(plugin.getClass().getCanonicalName());
        this.pluginPrincipal = new NamedPrincipal(principal);
        this.pluginUser = new User(principal);
    }

    public Principal getPrincipal() {
        return this.pluginPrincipal;
    }

    public <E extends Exception> void runAs(CheckedRunnable<E> r) throws E {
        try (ThreadContext.StoredContext ctx = this.threadPool.getThreadContext().stashContext();){
            this.threadPool.getThreadContext().putTransient("_opendistro_security_user", (Object)this.pluginUser);
            r.run();
        }
    }
}

