/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.spi.resources.sharing;

import java.io.IOException;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.opensearch.core.common.io.stream.NamedWriteable;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.security.spi.resources.sharing.Recipient;
import org.opensearch.security.spi.resources.sharing.Recipients;

public class ShareWith
implements ToXContentFragment,
NamedWriteable {
    private final Map<String, Recipients> sharingInfo;

    public ShareWith(Map<String, Recipients> sharingInfo) {
        this.sharingInfo = sharingInfo;
    }

    public ShareWith(StreamInput in) throws IOException {
        this.sharingInfo = in.readMap(StreamInput::readString, Recipients::new);
    }

    public boolean isPublic() {
        return this.sharingInfo.values().stream().anyMatch(Recipients::isPublic);
    }

    public boolean isPrivate() {
        return this.sharingInfo == null || this.sharingInfo.isEmpty();
    }

    public Set<String> accessLevels() {
        return this.sharingInfo.keySet();
    }

    public Map<String, Recipients> getSharingInfo() {
        return this.sharingInfo;
    }

    public Recipients atAccessLevel(String accessLevel) {
        return this.sharingInfo.get(accessLevel);
    }

    public ShareWith updateSharingInfo(String accessLevel, Recipients target) {
        this.sharingInfo.put(accessLevel, target);
        return this;
    }

    public XContentBuilder toXContent(XContentBuilder b, ToXContent.Params params) throws IOException {
        b.startObject();
        for (Map.Entry<String, Recipients> e : this.sharingInfo.entrySet()) {
            Recipients norm = ShareWith.pruneRecipients(e.getValue());
            if (norm == null) continue;
            b.field(e.getKey());
            norm.toXContent(b, params);
        }
        return b.endObject();
    }

    public static ShareWith fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        HashMap<String, Recipients> sharingInfo = new HashMap<String, Recipients>();
        if (parser.currentToken() != XContentParser.Token.START_OBJECT) {
            parser.nextToken();
        }
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token != XContentParser.Token.FIELD_NAME) continue;
            String accessLevel = parser.currentName();
            parser.nextToken();
            Recipients recipients = Recipients.fromXContent(parser);
            sharingInfo.put(accessLevel, recipients);
        }
        return new ShareWith(sharingInfo);
    }

    public String getWriteableName() {
        return "share_with";
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.sharingInfo, StreamOutput::writeString, (o, sw) -> sw.writeTo(o));
    }

    public String toString() {
        return "ShareWith " + String.valueOf(this.sharingInfo);
    }

    public ShareWith add(ShareWith other) {
        if (other == null || other.isPrivate()) {
            return this;
        }
        HashMap<String, Recipients> updated = new HashMap<String, Recipients>(this.sharingInfo);
        for (Map.Entry<String, Recipients> entry : other.sharingInfo.entrySet()) {
            String level = entry.getKey();
            Recipients patchRecipients = entry.getValue();
            updated.merge(level, patchRecipients, (orig, patchRec) -> {
                orig.share((Recipients)patchRec);
                return orig;
            });
        }
        return new ShareWith(updated);
    }

    public ShareWith revoke(ShareWith other) {
        if (this.sharingInfo.isEmpty() || other == null || other.isPrivate()) {
            return this;
        }
        HashMap<String, Recipients> updated = new HashMap<String, Recipients>(this.sharingInfo);
        for (Map.Entry<String, Recipients> entry : other.sharingInfo.entrySet()) {
            String level = entry.getKey();
            Recipients revokeRecipients = entry.getValue();
            updated.computeIfPresent(level, (lvl, orig) -> {
                orig.revoke(revokeRecipients);
                return orig;
            });
        }
        return new ShareWith(updated);
    }

    public ShareWith prune() {
        HashMap<String, Recipients> cleaned = new HashMap<String, Recipients>();
        for (Map.Entry<String, Recipients> e : this.sharingInfo.entrySet()) {
            Recipients prunedRecipients = ShareWith.pruneRecipients(e.getValue());
            if (prunedRecipients == null) continue;
            cleaned.put(e.getKey(), prunedRecipients);
        }
        return new ShareWith(cleaned);
    }

    private static Recipients pruneRecipients(Recipients r) {
        if (r == null) {
            return null;
        }
        Map<Recipient, Set<String>> src = r.getRecipients();
        if (src == null || src.isEmpty()) {
            return null;
        }
        EnumMap<Recipient, Set<String>> cleaned = new EnumMap<Recipient, Set<String>>(Recipient.class);
        for (Map.Entry<Recipient, Set<String>> e : src.entrySet()) {
            Set filtered;
            Set<String> vals = e.getValue();
            if (vals == null || (filtered = (Set)vals.stream().filter(s -> s != null && !s.isBlank()).collect(Collectors.toCollection(LinkedHashSet::new))).isEmpty()) continue;
            cleaned.put(e.getKey(), filtered);
        }
        return cleaned.isEmpty() ? null : new Recipients(cleaned);
    }
}

