/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.Colors;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.ULine;
import net.sourceforge.plantuml.klimt.shape.URectangle;
import net.sourceforge.plantuml.preproc.PreprocessingArtifact;
import net.sourceforge.plantuml.skin.UmlDiagramType;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.timingdiagram.Clocks;
import net.sourceforge.plantuml.timingdiagram.Highlight;
import net.sourceforge.plantuml.timingdiagram.Player;
import net.sourceforge.plantuml.timingdiagram.PlayerAnalog;
import net.sourceforge.plantuml.timingdiagram.PlayerBinary;
import net.sourceforge.plantuml.timingdiagram.PlayerClock;
import net.sourceforge.plantuml.timingdiagram.PlayerConcise;
import net.sourceforge.plantuml.timingdiagram.PlayerRectangle;
import net.sourceforge.plantuml.timingdiagram.PlayerRobust;
import net.sourceforge.plantuml.timingdiagram.TickInPlayer;
import net.sourceforge.plantuml.timingdiagram.TimeAxisStategy;
import net.sourceforge.plantuml.timingdiagram.TimeMessage;
import net.sourceforge.plantuml.timingdiagram.TimeTick;
import net.sourceforge.plantuml.timingdiagram.TimingFormat;
import net.sourceforge.plantuml.timingdiagram.TimingRuler;
import net.sourceforge.plantuml.timingdiagram.graphic.IntricatedPoint;
import net.sourceforge.plantuml.timingdiagram.graphic.Panels;
import net.sourceforge.plantuml.timingdiagram.graphic.TimeArrow;

public class TimingDiagram
extends UmlDiagram
implements Clocks {
    public static final double marginX1 = 5.0;
    private final double marginX2 = 5.0;
    private final Map<String, TimeTick> codes = new HashMap<String, TimeTick>();
    private final Map<String, Player> players = new LinkedHashMap<String, Player>();
    private final Map<String, PlayerClock> clocks = new HashMap<String, PlayerClock>();
    private final List<TimeMessage> messages = new ArrayList<TimeMessage>();
    private final List<Highlight> highlights = new ArrayList<Highlight>();
    private final TimingRuler ruler = new TimingRuler(this.getSkinParam());
    private TimeTick now;
    private Player lastPlayer;
    private TimeAxisStategy timeAxisStategy = TimeAxisStategy.AUTOMATIC;
    private boolean compactByDefault = false;
    private SimpleDateFormat sdf;

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(Timing Diagram)");
    }

    public TimingDiagram(UmlSource source, PreprocessingArtifact preprocessing) {
        super(source, UmlDiagramType.TIMING, null, preprocessing);
    }

    @Override
    protected ImageData exportDiagramInternal(OutputStream os, int index, FileFormatOption fileFormatOption) throws IOException {
        return this.createImageBuilder(fileFormatOption).drawable(this.getTextMainBlock(fileFormatOption)).write(os);
    }

    @Override
    protected TextBlock getTextMainBlock(FileFormatOption fileFormatOption) {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                TimingDiagram.this.drawInternal(ug);
            }

            @Override
            public XDimension2D calculateDimension(StringBounder stringBounder) {
                double withBeforeRuler = TimingDiagram.this.getPart1MaxWidth(stringBounder);
                double totalWith = withBeforeRuler + TimingDiagram.this.ruler.getWidth() + 5.0 + 5.0;
                return new XDimension2D(totalWith, TimingDiagram.this.getHeightTotal(stringBounder));
            }
        };
    }

    private StyleSignatureBasic getStyleSignature() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.timingDiagram);
    }

    private HColor black() {
        Style style = this.getStyleSignature().getMergedStyle(this.getSkinParam().getCurrentStyleBuilder());
        return style.value(PName.LineColor).asColor(this.getSkinParam().getIHtmlColorSet());
    }

    private void drawInternal(UGraphic ug) {
        UGraphic ugPlayer;
        this.ruler.ensureNotEmpty();
        StringBounder stringBounder = ug.getStringBounder();
        double part1MaxWidth = this.getPart1MaxWidth(stringBounder);
        for (Player player : this.players.values()) {
            HColor generalBackgroundColor = player.getGeneralBackgroundColor();
            if (generalBackgroundColor == null) continue;
            ugPlayer = ug.apply(this.getUTranslateForPlayerFrame(player, stringBounder));
            double fullHeight = player.getFrameHeight(stringBounder) + player.panels().getFullHeight(stringBounder);
            ugPlayer = ugPlayer.apply(generalBackgroundColor).apply(generalBackgroundColor.bg());
            ugPlayer.draw(URectangle.build(this.getWidthTotal(stringBounder), fullHeight));
        }
        UTranslate widthPart1 = UTranslate.dx(part1MaxWidth);
        if (!this.compactByDefault) {
            this.drawBorder(ug);
        }
        ug = ug.apply(UTranslate.dx(5.0));
        this.drawHighlightsBack(ug.apply(widthPart1));
        this.ruler.drawVlines(ug.apply(widthPart1), this.getHeightInner(stringBounder));
        for (Player player : this.players.values()) {
            ugPlayer = ug.apply(this.getUTranslateForPlayer(player, stringBounder));
            UGraphic ugFrame = ug.apply(this.getUTranslateForPlayerFrame(player, stringBounder));
            if (!player.isCompact()) {
                this.drawHorizontalSeparator(ugFrame);
            }
            player.drawFrameTitle(ugFrame);
            Panels panels = player.panels();
            panels.drawLeftPanel(ugPlayer, part1MaxWidth);
            panels.drawRightPanel(ugPlayer.apply(widthPart1));
        }
        ug = ug.apply(widthPart1);
        this.ruler.drawTimeAxis(ug.apply(this.getLastTranslate(stringBounder)), this.timeAxisStategy, this.codes);
        for (TimeMessage timeMessage : this.messages) {
            this.drawMessages(ug, timeMessage);
        }
        this.drawHighlightsLines(ug);
    }

    private void drawHorizontalSeparator(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        ug = ug.apply(this.black());
        ug = ug.apply(this.getBorderStroke());
        ug = ug.apply(UTranslate.dx(-5.0));
        ug.draw(ULine.hline(this.getWidthTotal(stringBounder)));
    }

    private void drawBorder(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        ULine border = ULine.vline(this.getLastTranslate(stringBounder).getDy());
        ug = ug.apply(this.black()).apply(this.getBorderStroke());
        ug.draw(border);
        ug.apply(UTranslate.dx(this.getWidthTotal(stringBounder))).draw(border);
    }

    private UStroke getBorderStroke() {
        return this.getStyleSignature().getMergedStyle(this.getCurrentStyleBuilder()).getStroke();
    }

    private UTranslate getLastTranslate(StringBounder stringBounder) {
        return this.getUTranslateForPlayer(null, stringBounder);
    }

    private void drawHighlightsBack(UGraphic ug) {
        double height = this.getHeightInner(ug.getStringBounder());
        for (Highlight highlight : this.highlights) {
            highlight.drawHighlightsBack(ug, this.ruler, height);
        }
    }

    private void drawHighlightsLines(UGraphic ug) {
        double height = this.getHeightInner(ug.getStringBounder());
        for (Highlight highlight : this.highlights) {
            highlight.drawHighlightsLines(ug, this.ruler, height);
            double start = this.ruler.getPosInPixel(highlight.getTickFrom());
            highlight.getCaption(this.getSkinParam()).drawU(ug.apply(new UTranslate(start + 3.0, 2.0)));
        }
    }

    private double getHeightTotal(StringBounder stringBounder) {
        return this.getHeightInner(stringBounder) + this.ruler.getHeight(stringBounder);
    }

    private double getHeightInner(StringBounder stringBounder) {
        return this.getLastTranslate(stringBounder).getDy();
    }

    private double getWidthTotal(StringBounder stringBounder) {
        return this.getPart1MaxWidth(stringBounder) + this.ruler.getWidth() + 5.0 + 5.0;
    }

    private double getPart1MaxWidth(StringBounder stringBounder) {
        double width = 0.0;
        for (Player player : this.players.values()) {
            double widthLeftPanel = player.panels().getLeftPanelWidth(stringBounder);
            width = Math.max(width, widthLeftPanel);
        }
        return width;
    }

    private void drawMessages(UGraphic ug, TimeMessage message) {
        Player player1 = message.getPlayer1();
        Player player2 = message.getPlayer2();
        StringBounder stringBounder = ug.getStringBounder();
        UTranslate translate1 = this.getUTranslateForPlayer(player1, stringBounder);
        UTranslate translate2 = this.getUTranslateForPlayer(player2, stringBounder);
        IntricatedPoint pt1 = player1.panels().getTimeProjection(stringBounder, message.getTick1());
        IntricatedPoint pt2 = player2.panels().getTimeProjection(stringBounder, message.getTick2());
        if (pt1 == null || pt2 == null) {
            return;
        }
        TimeArrow timeArrow = TimeArrow.create(pt1.translated(translate1), pt2.translated(translate2), message.getLabel(), this.getSkinParam(), message);
        timeArrow.drawU(ug);
    }

    private UTranslate getUTranslateForPlayer(Player candidat, StringBounder stringBounder) {
        double y = 0.0;
        for (Player player : this.players.values()) {
            y += player.getFrameHeight(stringBounder);
            if (candidat == player) {
                return UTranslate.dy(y);
            }
            y += player.panels().getFullHeight(stringBounder);
        }
        if (candidat == null) {
            return UTranslate.dy(y);
        }
        throw new IllegalArgumentException();
    }

    private UTranslate getUTranslateForPlayerFrame(Player candidat, StringBounder stringBounder) {
        double y = 0.0;
        for (Player player : this.players.values()) {
            if (candidat == player) {
                return UTranslate.dy(y);
            }
            y += player.getFrameHeight(stringBounder);
            y += player.panels().getFullHeight(stringBounder);
        }
        if (candidat == null) {
            return UTranslate.dy(y);
        }
        throw new IllegalArgumentException();
    }

    public Player createPlayerRobust(String code, String full, boolean compact, Stereotype stereotype, HColor backColor) {
        PlayerRobust player = new PlayerRobust(full, this.getSkinParam(), this.ruler, this.compactByDefault || compact, stereotype, backColor);
        this.players.put(code, player);
        this.lastPlayer = player;
        return player;
    }

    public Player createPlayerConcise(String code, String full, boolean compact, Stereotype stereotype, HColor backColor) {
        PlayerConcise player = new PlayerConcise(full, this.getSkinParam(), this.ruler, this.compactByDefault || compact, stereotype, backColor);
        this.players.put(code, player);
        this.lastPlayer = player;
        return player;
    }

    public Player createPlayerRectangle(String code, String full, boolean compact, Stereotype stereotype, HColor backColor) {
        PlayerRectangle player = new PlayerRectangle(full, this.getSkinParam(), this.ruler, this.compactByDefault || compact, stereotype, backColor);
        this.players.put(code, player);
        this.lastPlayer = player;
        return player;
    }

    public PlayerClock createPlayerClock(String code, String full, int period, int pulse, int offset, boolean compact, Stereotype stereotype) {
        PlayerClock player = new PlayerClock(full, this.getSkinParam(), this.ruler, period, pulse, offset, this.compactByDefault, stereotype);
        this.players.put(code, player);
        this.clocks.put(code, player);
        TimeTick tick = new TimeTick(new BigDecimal(period), TimingFormat.DECIMAL);
        this.ruler.addTime(tick);
        return player;
    }

    public PlayerAnalog createPlayerAnalog(String code, String full, boolean compact, Stereotype stereotype) {
        PlayerAnalog player = new PlayerAnalog(full, this.getSkinParam(), this.ruler, this.compactByDefault, stereotype);
        this.players.put(code, player);
        return player;
    }

    public Player createPlayerBinary(String code, String full, boolean compact, Stereotype stereotype) {
        PlayerBinary player = new PlayerBinary(full, this.getSkinParam(), this.ruler, this.compactByDefault, stereotype);
        this.players.put(code, player);
        return player;
    }

    public TimeMessage createTimeMessage(Player player1, TimeTick time1, Player player2, TimeTick time2, String label) {
        TimeMessage message = new TimeMessage(new TickInPlayer(player1, time1), new TickInPlayer(player2, time2), label, this.getSkinParam());
        this.messages.add(message);
        return message;
    }

    public void addTime(TimeTick time, String code) {
        this.now = time;
        this.ruler.addTime(time);
        if (code != null) {
            this.codes.put(code, time);
        }
    }

    @Override
    public TimeTick getCodeValue(String code) {
        return this.codes.get(code);
    }

    public void updateNow(TimeTick time) {
        this.now = time;
    }

    public Player getPlayer(String code) {
        return this.players.get(code);
    }

    @Override
    public TimeTick getNow() {
        return this.now;
    }

    @Override
    public TimeTick getClockValue(String clockName, int nb) {
        PlayerClock clock = this.clocks.get(clockName);
        if (clock == null) {
            return null;
        }
        return new TimeTick(new BigDecimal(nb * clock.getPeriod()), TimingFormat.DECIMAL);
    }

    public void setLastPlayer(Player player) {
        this.lastPlayer = player;
    }

    public Player getLastPlayer() {
        return this.lastPlayer;
    }

    public void scaleInPixels(long tick, long pixel) {
        this.ruler.scaleInPixels(tick, pixel);
    }

    public CommandExecutionResult setTimeAxisStategy(TimeAxisStategy newStrategy) {
        this.timeAxisStategy = newStrategy;
        return CommandExecutionResult.ok();
    }

    public CommandExecutionResult highlight(TimeTick tickFrom, TimeTick tickTo, Display caption, Colors colors) {
        this.highlights.add(new Highlight(this.getSkinParam(), tickFrom, tickTo, caption, colors));
        return CommandExecutionResult.ok();
    }

    public void goCompactMode() {
        this.compactByDefault = true;
    }

    public CommandExecutionResult useDateFormat(String dateFormat) {
        try {
            this.sdf = new SimpleDateFormat(dateFormat, Locale.US);
        }
        catch (Exception e) {
            return CommandExecutionResult.error("Bad date format");
        }
        return CommandExecutionResult.ok();
    }

    @Override
    public TimingFormat getTimingFormatDate() {
        if (this.sdf == null) {
            return TimingFormat.DATE;
        }
        return TimingFormat.create(this.sdf);
    }

    public void setStopAt(TimeTick timeTick) {
        this.ruler.setStopAt(timeTick);
    }
}

