/*
 * Decompiled with CFR 0.152.
 */
package com.j256.simplemagic.types;

import com.j256.simplemagic.endian.EndianType;
import com.j256.simplemagic.types.BaseLongType;
import com.j256.simplemagic.types.LongType;

public class IntegerType
extends BaseLongType {
    private static final int BYTES_PER_INTEGER = 4;

    public IntegerType(EndianType endianType) {
        super(endianType);
    }

    @Override
    public int getBytesPerType() {
        return 4;
    }

    @Override
    public long maskValue(long value) {
        return value & 0xFFFFFFFFL;
    }

    @Override
    public int compare(boolean unsignedType, Number extractedValue, Number testValue) {
        int testInt;
        if (unsignedType) {
            return LongType.staticCompare(extractedValue, testValue);
        }
        int extractedInt = extractedValue.intValue();
        if (extractedInt > (testInt = testValue.intValue())) {
            return 1;
        }
        if (extractedInt < testInt) {
            return -1;
        }
        return 0;
    }
}

