/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.ltr.store.rest;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.ltr.feature.Feature;
import org.apache.solr.ltr.model.AdapterModel;
import org.apache.solr.ltr.model.LTRScoringModel;
import org.apache.solr.ltr.model.ModelException;
import org.apache.solr.ltr.model.WrapperModel;
import org.apache.solr.ltr.norm.IdentityNormalizer;
import org.apache.solr.ltr.norm.Normalizer;
import org.apache.solr.ltr.store.FeatureStore;
import org.apache.solr.ltr.store.ModelStore;
import org.apache.solr.ltr.store.rest.ManagedFeatureStore;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.rest.BaseSolrResource;
import org.apache.solr.rest.ManagedResource;
import org.apache.solr.rest.ManagedResourceObserver;
import org.apache.solr.rest.ManagedResourceStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedModelStore
extends ManagedResource
implements ManagedResource.ChildResourceSupport {
    public static final String REST_END_POINT = "/schema/model-store";
    private static final String MODELS_JSON_FIELD = "models";
    static final String CLASS_KEY = "class";
    static final String FEATURES_KEY = "features";
    static final String NAME_KEY = "name";
    static final String NORM_KEY = "norm";
    static final String PARAMS_KEY = "params";
    static final String STORE_KEY = "store";
    private final ModelStore store = new ModelStore();
    private ManagedFeatureStore managedFeatureStore;
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private Object managedData;

    public static void registerManagedModelStore(SolrResourceLoader solrResourceLoader, ManagedResourceObserver managedResourceObserver) {
        solrResourceLoader.getManagedResourceRegistry().registerManagedResource(REST_END_POINT, ManagedModelStore.class, managedResourceObserver);
    }

    public static ManagedModelStore getManagedModelStore(SolrCore core) {
        return (ManagedModelStore)core.getRestManager().getManagedResource(REST_END_POINT);
    }

    public ManagedModelStore(String resourceId, SolrResourceLoader loader, ManagedResourceStorage.StorageIO storageIO) throws SolrException {
        super(resourceId, loader, storageIO);
    }

    protected ManagedResourceStorage createStorage(ManagedResourceStorage.StorageIO storageIO, SolrResourceLoader loader) throws SolrException {
        return new ManagedResourceStorage.JsonStorage(storageIO, loader, -1);
    }

    public void setManagedFeatureStore(ManagedFeatureStore managedFeatureStore) {
        log.info("INIT model store");
        this.managedFeatureStore = managedFeatureStore;
    }

    public ManagedFeatureStore getManagedFeatureStore() {
        return this.managedFeatureStore;
    }

    protected void onManagedDataLoadedFromStorage(NamedList<?> managedInitArgs, Object managedData) throws SolrException {
        this.store.clear();
        this.managedData = managedData;
    }

    public void loadStoredModels() {
        log.info("------ managed models ~ loading ------");
        if (this.managedData != null && this.managedData instanceof List) {
            List up = (List)this.managedData;
            for (Map u : up) {
                this.addModelFromMap(u);
            }
        }
    }

    private void addModelFromMap(Map<String, Object> modelMap) {
        try {
            LTRScoringModel algo = ManagedModelStore.fromLTRScoringModelMap(this.solrResourceLoader, modelMap, this.managedFeatureStore);
            this.addModel(algo);
        }
        catch (ModelException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
        }
    }

    public synchronized void addModel(LTRScoringModel ltrScoringModel) throws ModelException {
        try {
            if (log.isInfoEnabled()) {
                log.info("adding model {}", (Object)ltrScoringModel.getName());
            }
            this.store.addModel(ltrScoringModel);
        }
        catch (ModelException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
        }
    }

    protected Object applyUpdatesToManagedData(Object updates) {
        if (updates instanceof List) {
            List up = (List)updates;
            for (Map u : up) {
                this.addModelFromMap(u);
            }
        }
        if (updates instanceof Map) {
            Map map = (Map)updates;
            this.addModelFromMap(map);
        }
        return ManagedModelStore.modelsAsManagedResources(this.store.getModels());
    }

    public synchronized void doDeleteChild(BaseSolrResource endpoint, String childId) {
        this.store.delete(childId);
        this.storeManagedData(this.applyUpdatesToManagedData(null));
    }

    public void doGet(BaseSolrResource endpoint, String childId) {
        SolrQueryResponse response = endpoint.getSolrResponse();
        response.add(MODELS_JSON_FIELD, ManagedModelStore.modelsAsManagedResources(this.store.getModels()));
    }

    public LTRScoringModel getModel(String modelName) {
        return this.store.getModel(modelName);
    }

    public String toString() {
        return "ManagedModelStore [store=" + String.valueOf(this.store) + ", featureStores=" + String.valueOf((Object)this.managedFeatureStore) + "]";
    }

    private static List<Object> modelsAsManagedResources(List<LTRScoringModel> models) {
        ArrayList<Object> list = new ArrayList<Object>(models.size());
        for (LTRScoringModel model : models) {
            list.add(ManagedModelStore.toLTRScoringModelMap(model));
        }
        return list;
    }

    public static LTRScoringModel fromLTRScoringModelMap(SolrResourceLoader solrResourceLoader, Map<String, Object> modelMap, ManagedFeatureStore managedFeatureStore) {
        LTRScoringModel ltrScoringModel;
        FeatureStore featureStore = managedFeatureStore.getFeatureStore((String)modelMap.get(STORE_KEY));
        ArrayList<Feature> features = new ArrayList<Feature>();
        ArrayList<Normalizer> norms = new ArrayList<Normalizer>();
        List featureList = (List)modelMap.get(FEATURES_KEY);
        if (featureList != null) {
            for (Object feature : featureList) {
                Map featureMap = (Map)feature;
                features.add(ManagedModelStore.lookupFeatureFromFeatureMap(featureMap, featureStore));
                norms.add(ManagedModelStore.createNormalizerFromFeatureMap(solrResourceLoader, featureMap));
            }
        }
        if ((ltrScoringModel = LTRScoringModel.getInstance(solrResourceLoader, (String)modelMap.get(CLASS_KEY), (String)modelMap.get(NAME_KEY), features, norms, featureStore.getName(), featureStore.getFeatures(), (Map)modelMap.get(PARAMS_KEY))) instanceof AdapterModel) {
            ManagedModelStore.initAdapterModel(solrResourceLoader, (AdapterModel)ltrScoringModel, managedFeatureStore);
        }
        return ltrScoringModel;
    }

    private static void initAdapterModel(SolrResourceLoader solrResourceLoader, AdapterModel adapterModel, ManagedFeatureStore managedFeatureStore) {
        adapterModel.init(solrResourceLoader);
        if (adapterModel instanceof WrapperModel) {
            ManagedModelStore.initWrapperModel(solrResourceLoader, (WrapperModel)adapterModel, managedFeatureStore);
        }
    }

    private static void initWrapperModel(SolrResourceLoader solrResourceLoader, WrapperModel wrapperModel, ManagedFeatureStore managedFeatureStore) {
        LTRScoringModel model = ManagedModelStore.fromLTRScoringModelMap(solrResourceLoader, wrapperModel.fetchModelMap(), managedFeatureStore);
        if (model instanceof AdapterModel) {
            ManagedModelStore.initAdapterModel(solrResourceLoader, (AdapterModel)model, managedFeatureStore);
        }
        wrapperModel.updateModel(model);
    }

    private static LinkedHashMap<String, Object> toLTRScoringModelMap(LTRScoringModel model) {
        LinkedHashMap<String, Object> modelMap = new LinkedHashMap<String, Object>(5, 1.0f);
        modelMap.put(NAME_KEY, model.getName());
        modelMap.put(CLASS_KEY, model.getClass().getName());
        modelMap.put(STORE_KEY, model.getFeatureStoreName());
        ArrayList<LinkedHashMap<String, Object>> features = new ArrayList<LinkedHashMap<String, Object>>();
        if (!(model instanceof WrapperModel)) {
            List<Feature> featuresList = model.getFeatures();
            List<Normalizer> normsList = model.getNorms();
            for (int ii = 0; ii < featuresList.size(); ++ii) {
                features.add(ManagedModelStore.toFeatureMap(featuresList.get(ii), normsList.get(ii)));
            }
        }
        modelMap.put(FEATURES_KEY, features);
        modelMap.put(PARAMS_KEY, model.getParams());
        return modelMap;
    }

    private static Feature lookupFeatureFromFeatureMap(Map<String, Object> featureMap, FeatureStore featureStore) {
        Feature extractedFromStore;
        String featureName = (String)featureMap.get(NAME_KEY);
        Feature feature = extractedFromStore = featureName == null ? null : featureStore.get(featureName);
        if (extractedFromStore == null) {
            if (featureStore.getFeatures().isEmpty()) {
                throw new ModelException("Missing or empty feature store: " + featureStore.getName());
            }
            throw new ModelException("Feature: " + featureName + " not found in store: " + featureStore.getName());
        }
        return extractedFromStore;
    }

    private static Normalizer createNormalizerFromFeatureMap(SolrResourceLoader solrResourceLoader, Map<String, Object> featureMap) {
        Map normMap = (Map)featureMap.get(NORM_KEY);
        return normMap == null ? IdentityNormalizer.INSTANCE : ManagedModelStore.fromNormalizerMap(solrResourceLoader, normMap);
    }

    private static LinkedHashMap<String, Object> toFeatureMap(Feature feature, Normalizer norm) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(2, 1.0f);
        map.put(NAME_KEY, feature.getName());
        map.put(NORM_KEY, ManagedModelStore.toNormalizerMap(norm));
        return map;
    }

    private static Normalizer fromNormalizerMap(SolrResourceLoader solrResourceLoader, Map<String, Object> normMap) {
        String className = (String)normMap.get(CLASS_KEY);
        Map params = (Map)normMap.get(PARAMS_KEY);
        return Normalizer.getInstance(solrResourceLoader, className, params);
    }

    private static LinkedHashMap<String, Object> toNormalizerMap(Normalizer norm) {
        LinkedHashMap<String, Object> normalizer = new LinkedHashMap<String, Object>(2, 1.0f);
        normalizer.put(CLASS_KEY, norm.getClass().getName());
        LinkedHashMap<String, Object> params = norm.paramsToMap();
        if (params != null) {
            normalizer.put(PARAMS_KEY, params);
        }
        return normalizer;
    }
}

