/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.feature.jts;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.apache.sis.internal.feature.j2d.EmptyShape;
import org.apache.sis.internal.feature.jts.Factory;
import org.apache.sis.internal.feature.jts.PathIteratorAdapter;
import org.apache.sis.internal.referencing.j2d.AbstractShape;
import org.apache.sis.internal.referencing.j2d.IntervalRectangle;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Point;

final class ShapeAdapter
extends AbstractShape
implements Serializable {
    private static final long serialVersionUID = -8536828815289601141L;
    private static final GeometryFactory SMALL_FACTORY = new GeometryFactory();
    protected final Geometry geometry;

    protected ShapeAdapter(Geometry geometry) {
        this.geometry = geometry;
    }

    protected boolean isFloat() {
        CoordinateSequence coordinateSequence;
        if (this.geometry instanceof Point) {
            coordinateSequence = ((Point)this.geometry).getCoordinateSequence();
        } else if (this.geometry instanceof LineString) {
            coordinateSequence = ((LineString)this.geometry).getCoordinateSequence();
        } else {
            return super.isFloat();
        }
        return Factory.isFloat(coordinateSequence);
    }

    public Rectangle getBounds() {
        return this.getBounds2D().getBounds();
    }

    public Rectangle2D getBounds2D() {
        Envelope envelope = this.geometry.getEnvelopeInternal();
        return new IntervalRectangle(envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY());
    }

    public boolean contains(Point2D point2D) {
        return this.contains(point2D.getX(), point2D.getY());
    }

    public boolean contains(double d, double d2) {
        return this.geometry.contains((Geometry)SMALL_FACTORY.createPoint(new Coordinate(d, d2)));
    }

    public boolean contains(Rectangle2D rectangle2D) {
        return this.geometry.contains(ShapeAdapter.createRect(rectangle2D.getMinX(), rectangle2D.getMinY(), rectangle2D.getMaxX(), rectangle2D.getMaxY()));
    }

    public boolean contains(double d, double d2, double d3, double d4) {
        return this.geometry.contains(ShapeAdapter.createRect(d, d2, d + d3, d2 + d4));
    }

    public boolean intersects(Rectangle2D rectangle2D) {
        return this.geometry.intersects(ShapeAdapter.createRect(rectangle2D.getMinX(), rectangle2D.getMinY(), rectangle2D.getMaxX(), rectangle2D.getMaxY()));
    }

    public boolean intersects(double d, double d2, double d3, double d4) {
        return this.geometry.intersects(ShapeAdapter.createRect(d, d2, d + d3, d2 + d4));
    }

    private static Geometry createRect(double d, double d2, double d3, double d4) {
        Coordinate coordinate = new Coordinate(d, d2);
        LinearRing linearRing = SMALL_FACTORY.createLinearRing(new Coordinate[]{coordinate, new Coordinate(d, d4), new Coordinate(d3, d4), new Coordinate(d3, d2), coordinate});
        return SMALL_FACTORY.createPolygon(linearRing);
    }

    public PathIterator getPathIterator(AffineTransform affineTransform, double d) {
        return this.getPathIterator(affineTransform);
    }

    public PathIterator getPathIterator(AffineTransform affineTransform) {
        if (this.geometry.isEmpty()) {
            return EmptyShape.INSTANCE;
        }
        return new PathIteratorAdapter(this.geometry, affineTransform);
    }
}

