/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.chm.lzx;

import org.apache.tika.parser.chm.accessor.ChmLzxcControlData;
import org.apache.tika.parser.chm.accessor.DirectoryListingEntry;
import org.apache.tika.parser.chm.exception.ChmParsingException;

public class ChmBlockInfo {
    private int iniBlock;
    private int startBlock;
    private int endBlock;
    private int startOffset;
    private int endOffset;

    private ChmBlockInfo() {
    }

    @Deprecated
    public static ChmBlockInfo getChmBlockInfoInstance(DirectoryListingEntry dle, int bytesPerBlock, ChmLzxcControlData clcd) throws ChmParsingException {
        return ChmBlockInfo.getChmBlockInfoInstance(dle, bytesPerBlock, clcd, new ChmBlockInfo());
    }

    public static ChmBlockInfo getChmBlockInfoInstance(DirectoryListingEntry dle, int bytesPerBlock, ChmLzxcControlData clcd, ChmBlockInfo chmBlockInfo) throws ChmParsingException {
        if (chmBlockInfo == null) {
            chmBlockInfo = new ChmBlockInfo();
        }
        if (!ChmBlockInfo.validateParameters(dle, bytesPerBlock, clcd, chmBlockInfo)) {
            throw new ChmParsingException("Please check you parameters");
        }
        chmBlockInfo.setStartBlock(dle.getOffset() / bytesPerBlock);
        chmBlockInfo.setEndBlock((dle.getOffset() + dle.getLength()) / bytesPerBlock);
        chmBlockInfo.setStartOffset(dle.getOffset() % bytesPerBlock);
        chmBlockInfo.setEndOffset((dle.getOffset() + dle.getLength()) % bytesPerBlock);
        chmBlockInfo.setIniBlock(chmBlockInfo.startBlock - chmBlockInfo.startBlock % (int)clcd.getResetInterval());
        return chmBlockInfo;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("iniBlock:=" + this.getIniBlock() + ", ");
        sb.append("startBlock:=" + this.getStartBlock() + ", ");
        sb.append("endBlock:=" + this.getEndBlock() + ", ");
        sb.append("startOffset:=" + this.getStartOffset() + ", ");
        sb.append("endOffset:=" + this.getEndOffset() + System.getProperty("line.separator"));
        return sb.toString();
    }

    private static boolean validateParameters(DirectoryListingEntry dle, int bytesPerBlock, ChmLzxcControlData clcd, ChmBlockInfo chmBlockInfo) {
        int goodParameter = 0;
        if (dle != null) {
            ++goodParameter;
        }
        if (bytesPerBlock > 0) {
            ++goodParameter;
        }
        if (clcd != null) {
            ++goodParameter;
        }
        if (chmBlockInfo != null) {
            ++goodParameter;
        }
        return goodParameter == 4;
    }

    public static void main(String[] args) {
    }

    public int getIniBlock() {
        return this.iniBlock;
    }

    private void setIniBlock(int iniBlock) {
        this.iniBlock = iniBlock;
    }

    public int getStartBlock() {
        return this.startBlock;
    }

    private void setStartBlock(int startBlock) {
        this.startBlock = startBlock;
    }

    public int getEndBlock() {
        return this.endBlock;
    }

    private void setEndBlock(int endBlock) {
        this.endBlock = endBlock;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    private void setStartOffset(int startOffset) {
        this.startOffset = startOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    private void setEndOffset(int endOffset) {
        this.endOffset = endOffset;
    }
}

