/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset.conv;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import ucar.nc2.Attribute;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordSysBuilder;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableEnhanced;
import ucar.nc2.units.DateFormatter;
import ucar.nc2.util.CancelTask;

public class Suomi
extends CoordSysBuilder {
    public static boolean isMine(NetcdfFile ncfile) {
        Variable v = ncfile.findVariable("time_offset");
        if (v == null || !v.isCoordinateVariable()) {
            return false;
        }
        String desc = v.getDescription();
        if (desc == null || !desc.equals("Time delta from start_time") && !desc.equals("PWV window midpoint time delta from start_time")) {
            return false;
        }
        if (null == ncfile.findGlobalAttribute("start_date")) {
            return false;
        }
        return null != ncfile.findGlobalAttribute("start_time");
    }

    public Suomi() {
        this.conventionName = "Suomi";
    }

    @Override
    public void augmentDataset(NetcdfDataset ds, CancelTask cancelTask) throws IOException {
        Date start;
        String start_date = ds.findAttValueIgnoreCase(null, "start_date", null);
        if (start_date == null) {
            return;
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy.DDD.HH.mm.ss");
        DateFormatter dfo = new DateFormatter();
        try {
            start = df.parse(start_date);
        }
        catch (ParseException e) {
            throw new RuntimeException("Cant read start_date=" + start_date);
        }
        Variable v = ds.findVariable("time_offset");
        v.addAttribute(new Attribute("units", "seconds since " + dfo.toDateTimeString(start)));
        Group root = ds.getRootGroup();
        root.addAttribute(new Attribute("Conventions", "Suomi-Station-CDM"));
        ds.finish();
    }

    @Override
    protected AxisType getAxisType(NetcdfDataset ncDataset, VariableEnhanced v) {
        String name = v.getShortName();
        if (name.equals("time_offset")) {
            return AxisType.Time;
        }
        if (name.equals("lat")) {
            return AxisType.Lat;
        }
        if (name.equals("lon")) {
            return AxisType.Lon;
        }
        if (name.equals("height")) {
            return AxisType.Height;
        }
        return null;
    }
}

