/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.io.IOException;
import org.apache.lucene.store.ByteBuffersDirectory;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.SingleInstanceLockFactory;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.DirectoryFactory;
import org.apache.solr.core.EphemeralDirectoryFactory;

public class RAMDirectoryFactory
extends EphemeralDirectoryFactory {
    @Override
    protected LockFactory createLockFactory(String rawLockType) throws IOException {
        if (rawLockType != null && !"single".equalsIgnoreCase(rawLockType.trim())) {
            throw new SolrException(SolrException.ErrorCode.FORBIDDEN, "RAMDirectory can only be used with the 'single' lock factory type.");
        }
        return new SingleInstanceLockFactory();
    }

    @Override
    protected Directory create(String path, LockFactory lockFactory, DirectoryFactory.DirContext dirContext) throws IOException {
        return new ByteBuffersDirectory(lockFactory);
    }
}

