/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import jakarta.inject.Inject;
import java.util.HashMap;
import java.util.Locale;
import org.apache.solr.client.api.endpoint.BalanceShardUniqueApi;
import org.apache.solr.client.api.model.BalanceShardUniqueRequestBody;
import org.apache.solr.client.api.model.SubResponseAccumulatingJerseyResponse;
import org.apache.solr.cloud.overseer.SliceMutator;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.admin.api.AdminAPIBase;
import org.apache.solr.handler.api.V2ApiUtils;
import org.apache.solr.jersey.PermissionName;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.PermissionNameProvider;

public class BalanceShardUnique
extends AdminAPIBase
implements BalanceShardUniqueApi {
    @Inject
    public BalanceShardUnique(CoreContainer coreContainer, SolrQueryRequest solrQueryRequest, SolrQueryResponse solrQueryResponse) {
        super(coreContainer, solrQueryRequest, solrQueryResponse);
    }

    @PermissionName(value=PermissionNameProvider.Name.COLL_EDIT_PERM)
    public SubResponseAccumulatingJerseyResponse balanceShardUnique(String collectionName, BalanceShardUniqueRequestBody requestBody) throws Exception {
        SubResponseAccumulatingJerseyResponse response = this.instantiateJerseyResponse(SubResponseAccumulatingJerseyResponse.class);
        if (requestBody == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Missing required request body");
        }
        this.ensureRequiredParameterProvided("collection", collectionName);
        this.ensureRequiredParameterProvided("property", requestBody.property);
        this.validatePropertyToBalance(requestBody.property, Boolean.TRUE.equals(requestBody.shardUnique));
        this.fetchAndValidateZooKeeperAwareCoreContainer();
        BalanceShardUnique.recordCollectionForLogAndTracing(collectionName, this.solrQueryRequest);
        ZkNodeProps remoteMessage = BalanceShardUnique.createRemoteMessage(collectionName, requestBody);
        this.submitRemoteMessageAndHandleResponse(response, CollectionParams.CollectionAction.BALANCESHARDUNIQUE, remoteMessage, requestBody.async);
        return response;
    }

    public static ZkNodeProps createRemoteMessage(String collectionName, BalanceShardUniqueRequestBody requestBody) {
        HashMap<String, Object> remoteMessage = new HashMap<String, Object>();
        remoteMessage.put("operation", CollectionParams.CollectionAction.BALANCESHARDUNIQUE.toLower());
        remoteMessage.put("collection", collectionName);
        remoteMessage.put("property", requestBody.property);
        BalanceShardUnique.insertIfNotNull(remoteMessage, "onlyactivenodes", requestBody.onlyActiveNodes);
        BalanceShardUnique.insertIfNotNull(remoteMessage, "shardUnique", requestBody.shardUnique);
        BalanceShardUnique.insertIfNotNull(remoteMessage, "async", requestBody.async);
        return new ZkNodeProps(remoteMessage);
    }

    public static void invokeFromV1Params(CoreContainer coreContainer, SolrQueryRequest solrQueryRequest, SolrQueryResponse solrQueryResponse) throws Exception {
        BalanceShardUnique api = new BalanceShardUnique(coreContainer, solrQueryRequest, solrQueryResponse);
        SolrParams params = solrQueryRequest.getParams();
        params.required().check(new String[]{"collection", "property"});
        String collection = params.get("collection");
        BalanceShardUniqueRequestBody requestBody = new BalanceShardUniqueRequestBody();
        requestBody.property = params.get("property");
        requestBody.onlyActiveNodes = params.getBool("onlyactivenodes");
        requestBody.shardUnique = params.getBool("shardUnique");
        requestBody.async = params.get("async");
        V2ApiUtils.squashIntoSolrResponseWithoutHeader(solrQueryResponse, api.balanceShardUnique(collection, requestBody));
    }

    private void validatePropertyToBalance(String prop, boolean shardUnique) {
        if (!((String)(prop = ((String)prop).toLowerCase(Locale.ROOT))).startsWith("property.")) {
            prop = "property." + (String)prop;
        }
        if (!shardUnique && !SliceMutator.SLICE_UNIQUE_BOOLEAN_PROPERTIES.contains(prop)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Balancing properties amongst replicas in a slice requires that the property be pre-defined as a unique property (e.g. 'preferredLeader') or that 'shardUnique' be set to 'true'.  Property: " + (String)prop + " shardUnique: " + shardUnique);
        }
    }
}

