/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.rest;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.rest.BaseSolrResource;
import org.apache.solr.rest.ManagedResourceObserver;
import org.apache.solr.rest.ManagedResourceStorage;
import org.apache.solr.rest.RestManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ManagedResource {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String INIT_ARGS_JSON_FIELD = "initArgs";
    public static final String MANAGED_JSON_LIST_FIELD = "managedList";
    public static final String MANAGED_JSON_MAP_FIELD = "managedMap";
    public static final String INITIALIZED_ON_JSON_FIELD = "initializedOn";
    public static final String UPDATED_SINCE_INIT_JSON_FIELD = "updatedSinceInit";
    private final String resourceId;
    protected final SolrResourceLoader solrResourceLoader;
    protected final ManagedResourceStorage storage;
    protected NamedList<Object> managedInitArgs;
    protected Date initializedOn;
    protected Date lastUpdateSinceInitialization;

    protected ManagedResource(String resourceId, SolrResourceLoader loader, ManagedResourceStorage.StorageIO storageIO) throws SolrException {
        this.resourceId = resourceId;
        this.solrResourceLoader = loader;
        this.storage = this.createStorage(storageIO, loader);
    }

    public void loadManagedDataAndNotify(Collection<ManagedResourceObserver> observers) throws SolrException {
        this.reloadFromStorage();
        this.notifyObserversDuringInit(this.managedInitArgs, observers);
        this.initializedOn = new Date();
        this.lastUpdateSinceInitialization = null;
    }

    protected void notifyObserversDuringInit(NamedList<?> args, Collection<ManagedResourceObserver> observers) throws SolrException {
        if (observers == null || observers.isEmpty()) {
            return;
        }
        for (ManagedResourceObserver observer : observers) {
            NamedList clonedArgs = args.clone();
            observer.onManagedResourceInitialized(clonedArgs, this);
        }
        if (log.isInfoEnabled()) {
            log.info("Notified {} observers of {}", (Object)observers.size(), (Object)this.getResourceId());
        }
    }

    protected ManagedResourceStorage createStorage(ManagedResourceStorage.StorageIO storageIO, SolrResourceLoader loader) throws SolrException {
        return new ManagedResourceStorage.JsonStorage(storageIO, loader);
    }

    public SolrResourceLoader getResourceLoader() {
        return this.solrResourceLoader;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public Class<? extends BaseSolrResource> getServerResourceClass() {
        return RestManager.ManagedEndpoint.class;
    }

    protected boolean updateInitArgs(NamedList<?> updatedArgs) {
        if (updatedArgs == null || updatedArgs.size() == 0) {
            return false;
        }
        boolean madeChanges = false;
        if (!this.managedInitArgs.equals(updatedArgs)) {
            this.managedInitArgs = updatedArgs.clone();
            madeChanges = true;
        }
        return madeChanges;
    }

    protected synchronized void reloadFromStorage() throws SolrException {
        String resourceId = this.getResourceId();
        Object data = null;
        try {
            data = this.storage.load(resourceId);
        }
        catch (FileNotFoundException fnf) {
            log.warn("No stored data found for {}", (Object)resourceId);
        }
        catch (IOException ioExc) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Failed to load stored data for " + resourceId + " due to: " + String.valueOf(ioExc), (Throwable)ioExc);
        }
        Object managedData = this.processStoredData(data);
        if (this.managedInitArgs == null) {
            this.managedInitArgs = new NamedList();
        }
        this.onManagedDataLoadedFromStorage(this.managedInitArgs, managedData);
    }

    protected Object processStoredData(Object data) throws SolrException {
        Object managedData = null;
        if (data != null) {
            if (!(data instanceof Map)) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Stored data for " + this.resourceId + " is not a valid JSON object!");
            }
            Map jsonMap = (Map)data;
            Map initArgsMap = (Map)jsonMap.get(INIT_ARGS_JSON_FIELD);
            this.managedInitArgs = new NamedList(initArgsMap);
            log.info("Loaded initArgs {} for {}", this.managedInitArgs, (Object)this.resourceId);
            if (jsonMap.containsKey(MANAGED_JSON_LIST_FIELD)) {
                Object jsonList = jsonMap.get(MANAGED_JSON_LIST_FIELD);
                if (!(jsonList instanceof List)) {
                    String errMsg = String.format(Locale.ROOT, "Expected JSON array as value for %s but client sent a %s instead!", MANAGED_JSON_LIST_FIELD, jsonList.getClass().getName());
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, errMsg);
                }
                managedData = jsonList;
            } else if (jsonMap.containsKey(MANAGED_JSON_MAP_FIELD)) {
                Object jsonObj = jsonMap.get(MANAGED_JSON_MAP_FIELD);
                if (!(jsonObj instanceof Map)) {
                    String errMsg = String.format(Locale.ROOT, "Expected JSON map as value for %s but client sent a %s instead!", MANAGED_JSON_MAP_FIELD, jsonObj.getClass().getName());
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, errMsg);
                }
                managedData = jsonObj;
            }
        }
        return managedData;
    }

    protected abstract void onManagedDataLoadedFromStorage(NamedList<?> var1, Object var2) throws SolrException;

    public synchronized void storeManagedData(Object managedData) {
        Map<String, Object> toStore = this.buildMapToStore(managedData);
        String resourceId = this.getResourceId();
        try {
            this.storage.store(resourceId, toStore);
            this.lastUpdateSinceInitialization = new Date();
        }
        catch (Throwable storeErr) {
            if (this.initializedOn != null) {
                try {
                    this.reloadFromStorage();
                }
                catch (Exception reloadExc) {
                    log.error("Failed to load data from storage due to: {}", (Throwable)reloadExc);
                }
            }
            String errMsg = String.format(Locale.ROOT, "Failed to store data for %s due to: %s", resourceId, storeErr.toString());
            log.error(errMsg, storeErr);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, errMsg, storeErr);
        }
    }

    public String getInitializedOn() {
        return this.initializedOn == null ? null : this.initializedOn.toInstant().toString();
    }

    public String getUpdatedSinceInitialization() {
        return this.lastUpdateSinceInitialization == null ? null : this.lastUpdateSinceInitialization.toInstant().toString();
    }

    public boolean hasChangesSinceInitialization() {
        return this.lastUpdateSinceInitialization != null;
    }

    protected Map<String, Object> buildMapToStore(Object managedData) {
        LinkedHashMap<String, Object> toStore = new LinkedHashMap<String, Object>(4, 1.0f);
        toStore.put(INIT_ARGS_JSON_FIELD, this.convertNamedListToMap(this.managedInitArgs));
        String initializedOnStr = this.getInitializedOn();
        if (initializedOnStr != null) {
            toStore.put(INITIALIZED_ON_JSON_FIELD, initializedOnStr);
        }
        if (this.hasChangesSinceInitialization()) {
            toStore.put(UPDATED_SINCE_INIT_JSON_FIELD, this.getUpdatedSinceInitialization());
        }
        if (managedData != null) {
            if (managedData instanceof List || managedData instanceof Set) {
                toStore.put(MANAGED_JSON_LIST_FIELD, managedData);
            } else if (managedData instanceof Map) {
                toStore.put(MANAGED_JSON_MAP_FIELD, managedData);
            } else {
                throw new IllegalArgumentException("Invalid managed data type " + managedData.getClass().getName() + "! Only List, Set, or Map objects are supported by this ManagedResource!");
            }
        }
        return toStore;
    }

    protected Map<String, Object> convertNamedListToMap(NamedList<?> args) {
        LinkedHashMap<String, Object> argsMap = new LinkedHashMap<String, Object>();
        if (args != null) {
            for (Map.Entry entry : args) {
                argsMap.put((String)entry.getKey(), entry.getValue());
            }
        }
        return argsMap;
    }

    public void doPost(BaseSolrResource endpoint, Object json) {
        this.doPut(endpoint, json);
    }

    public synchronized void doPut(BaseSolrResource endpoint, Object json) {
        if (log.isInfoEnabled()) {
            log.info("Processing update to {}: {} is a {}", new Object[]{this.getResourceId(), json, json.getClass().getName()});
        }
        boolean updatedInitArgs = false;
        Object managedData = null;
        if (json instanceof Map) {
            Map jsonMap = (Map)json;
            if (jsonMap.containsKey(INIT_ARGS_JSON_FIELD) || jsonMap.containsKey(MANAGED_JSON_LIST_FIELD) || jsonMap.containsKey(MANAGED_JSON_MAP_FIELD)) {
                Map initArgsMap = (Map)jsonMap.get(INIT_ARGS_JSON_FIELD);
                updatedInitArgs = this.updateInitArgs(new NamedList(initArgsMap));
                if (jsonMap.containsKey(MANAGED_JSON_LIST_FIELD)) {
                    managedData = jsonMap.get(MANAGED_JSON_LIST_FIELD);
                } else if (jsonMap.containsKey(MANAGED_JSON_MAP_FIELD)) {
                    managedData = jsonMap.get(MANAGED_JSON_MAP_FIELD);
                }
            } else {
                managedData = jsonMap;
            }
        } else if (json instanceof List) {
            managedData = json;
        } else {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unsupported update format " + json.getClass().getName());
        }
        Object updated = null;
        if (managedData != null) {
            updated = this.applyUpdatesToManagedData(managedData);
        }
        if (updatedInitArgs || updated != null) {
            this.storeManagedData(updated);
        }
    }

    public void onResourceDeleted() throws IOException {
        this.storage.delete(this.resourceId);
    }

    protected abstract Object applyUpdatesToManagedData(Object var1);

    public abstract void doDeleteChild(BaseSolrResource var1, String var2);

    public abstract void doGet(BaseSolrResource var1, String var2);

    public static interface ChildResourceSupport {
    }
}

