/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import org.apache.lucene.util.FixedBitSet;
import org.apache.solr.search.BitDocSet;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocSet;

class MutableBitDocSet
extends BitDocSet {
    private MutableBitDocSet(FixedBitSet bits, int size) {
        super(bits, size);
    }

    public static MutableBitDocSet fromBitDocSet(BitDocSet bitDocSet) {
        return new MutableBitDocSet(bitDocSet.getFixedBitSetClone(), bitDocSet.size);
    }

    public static DocSet unwrapIfMutable(DocSet docSet) {
        if (docSet instanceof MutableBitDocSet) {
            MutableBitDocSet mutableBitDocSet = (MutableBitDocSet)docSet;
            return new BitDocSet(mutableBitDocSet.getBits(), mutableBitDocSet.size);
        }
        return docSet;
    }

    private void resetSize() {
        this.size = -1;
    }

    @Override
    public DocIterator iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public DocSet intersection(DocSet other) {
        if (!(other instanceof BitDocSet)) {
            return other.intersection(this);
        }
        FixedBitSet newbits = this.getFixedBitSet();
        newbits.and(other.getFixedBitSet());
        this.resetSize();
        return this;
    }

    @Override
    public int intersectionSize(DocSet other) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean intersects(DocSet other) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int unionSize(DocSet other) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int andNotSize(DocSet other) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addAllTo(FixedBitSet target) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DocSet andNot(DocSet other) {
        MutableBitDocSet.andNot(this.getFixedBitSet(), other);
        this.resetSize();
        return this;
    }

    @Override
    public DocSet union(DocSet other) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BitDocSet clone() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        return "MutableBitDocSet instance of " + super.toString();
    }
}

