/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.security;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.Utils;
import org.apache.solr.security.PermissionNameProvider;

class Permission {
    String name;
    Set<String> path;
    Set<String> role;
    Set<String> collections;
    Set<String> method;
    Map<String, Function<String[], Boolean>> params;
    PermissionNameProvider.Name wellknownName;
    Map<?, ?> originalConfig;
    static final Set<String> predefinedPermissionAllowedKeys = Set.of("collection", "role", "name", "index");
    static final Set<String> customPermissionAdditionalKeys = Set.of("method", "path", "params");
    static final Set<String> knownKeys = Stream.concat(predefinedPermissionAllowedKeys.stream(), customPermissionAdditionalKeys.stream()).collect(Collectors.toUnmodifiableSet());
    public static final Set<String> HTTP_METHODS = Set.of("GET", "POST", "DELETE", "PUT", "HEAD");

    private Permission() {
    }

    static Permission load(Map<?, ?> m) {
        Permission p = new Permission();
        p.originalConfig = new LinkedHashMap(m);
        String name = (String)m.get("name");
        if (!m.containsKey("role")) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "role not specified");
        }
        p.role = Permission.readValueAsSet(m, "role");
        if (PermissionNameProvider.Name.get(name) != null) {
            p.wellknownName = PermissionNameProvider.Name.get(name);
            for (String s : customPermissionAdditionalKeys) {
                if (!m.containsKey(s)) continue;
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, s + " is not a valid key for the permission : " + name);
            }
        } else if (!m.containsKey("path")) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Permission with name " + name + " is neither a pre-defined permission nor qualifies as a custom permission");
        }
        p.name = name;
        p.path = Permission.readSetSmart(name, m, "path");
        p.collections = Permission.readSetSmart(name, m, "collection");
        p.method = Permission.readSetSmart(name, m, "method");
        Map paramRules = (Map)m.get("params");
        if (paramRules != null) {
            p.params = new LinkedHashMap<String, Function<String[], Boolean>>();
            for (Map.Entry e : paramRules.entrySet()) {
                if (e.getValue() == null) {
                    p.params.put((String)e.getKey(), val -> val == null);
                    continue;
                }
                List<String> patternStrs = e.getValue() instanceof List ? (List<String>)e.getValue() : Collections.singletonList(e.getValue().toString());
                List patterns = patternStrs.stream().map(it -> it.startsWith("REGEX:") ? Pattern.compile(it.substring("REGEX:".length())) : it).collect(Collectors.toList());
                p.params.put((String)e.getKey(), val -> {
                    if (val == null) {
                        return false;
                    }
                    for (Object pattern : patterns) {
                        for (String s : val) {
                            if (!(pattern instanceof String ? pattern.equals(s) : pattern instanceof Pattern && ((Pattern)pattern).matcher(s).find())) continue;
                            return true;
                        }
                    }
                    return false;
                });
            }
        }
        return p;
    }

    private static Set<String> readSetSmart(String permissionName, Map<?, ?> m, String key) {
        if (PermissionNameProvider.values.containsKey(permissionName) && !m.containsKey(key) && "collection".equals(key)) {
            return PermissionNameProvider.Name.get((String)permissionName).collName;
        }
        Set<String> set = Permission.readValueAsSet(m, key);
        if ("method".equals(key)) {
            if (set != null) {
                for (String s : set) {
                    if (HTTP_METHODS.contains(s)) continue;
                    return null;
                }
            }
            return set;
        }
        return set == null ? Collections.singleton(null) : set;
    }

    static Set<String> readValueAsSet(Map<?, ?> m, String key) {
        HashSet<String> result = new HashSet<String>();
        Object val = m.get(key);
        if (val == null) {
            if ("collection".equals(key)) {
                return m.containsKey(key) ? Collections.singleton(null) : Collections.singleton("*");
            }
            return null;
        }
        if (val instanceof Collection) {
            Collection list = (Collection)val;
            for (Object o : list) {
                result.add(String.valueOf(o));
            }
        } else if (val instanceof String) {
            result.add((String)val);
        } else {
            throw new RuntimeException("Bad value for : " + key);
        }
        return result.isEmpty() ? null : Collections.unmodifiableSet(result);
    }

    public String toString() {
        return Utils.toJSONString(this.originalConfig);
    }
}

