/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.BaseHttpSolrClient;
import org.apache.solr.client.solrj.impl.BinaryRequestWriter;
import org.apache.solr.client.solrj.impl.BinaryResponseParser;
import org.apache.solr.client.solrj.impl.HttpSolrClientBuilderBase;
import org.apache.solr.client.solrj.impl.InputStreamResponseParser;
import org.apache.solr.client.solrj.impl.NoOpResponseParser;
import org.apache.solr.client.solrj.request.RequestWriter;
import org.apache.solr.client.solrj.util.AsyncListener;
import org.apache.solr.client.solrj.util.Cancellable;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.Utils;

public abstract class HttpSolrClientBase
extends SolrClient {
    protected static final String DEFAULT_PATH = "/select";
    protected static final Charset FALLBACK_CHARSET = StandardCharsets.UTF_8;
    private static final List<String> errPath = Arrays.asList("metadata", "error-class");
    protected final String serverBaseUrl;
    protected final long requestTimeoutMillis;
    protected final Set<String> urlParamNames;
    protected RequestWriter requestWriter = new BinaryRequestWriter();
    protected ResponseParser parser = new BinaryResponseParser();
    protected Set<String> defaultParserMimeTypes;
    protected final String basicAuthAuthorizationStr;

    protected HttpSolrClientBase(String serverBaseUrl, HttpSolrClientBuilderBase<?, ?> builder) {
        if (serverBaseUrl != null) {
            if (!serverBaseUrl.equals("/") && serverBaseUrl.endsWith("/")) {
                serverBaseUrl = serverBaseUrl.substring(0, serverBaseUrl.length() - 1);
            }
            if (serverBaseUrl.startsWith("//")) {
                serverBaseUrl = serverBaseUrl.substring(1, serverBaseUrl.length());
            }
            this.serverBaseUrl = serverBaseUrl;
        } else {
            this.serverBaseUrl = null;
        }
        this.requestTimeoutMillis = builder.getRequestTimeoutMillis();
        this.basicAuthAuthorizationStr = builder.basicAuthAuthorizationStr;
        if (builder.requestWriter != null) {
            this.requestWriter = builder.requestWriter;
        }
        if (builder.responseParser != null) {
            this.parser = builder.responseParser;
        }
        this.defaultCollection = builder.defaultCollection;
        this.urlParamNames = builder.urlParamNames != null ? builder.urlParamNames : Set.of();
    }

    protected String getRequestUrl(SolrRequest<?> solrRequest, String collection) throws MalformedURLException {
        return ClientUtils.buildRequestUrl(solrRequest, this.requestWriter, this.serverBaseUrl, collection);
    }

    protected ResponseParser responseParser(SolrRequest<?> solrRequest) {
        return solrRequest.getResponseParser() == null ? this.parser : solrRequest.getResponseParser();
    }

    @Deprecated(since="9.8", forRemoval=true)
    protected ModifiableSolrParams initalizeSolrParams(SolrRequest<?> solrRequest, ResponseParser parserToUse) {
        return this.initializeSolrParams(solrRequest, parserToUse);
    }

    protected ModifiableSolrParams initializeSolrParams(SolrRequest<?> solrRequest, ResponseParser parserToUse) {
        ModifiableSolrParams wparams = new ModifiableSolrParams(solrRequest.getParams());
        wparams.set("wt", parserToUse.getWriterType());
        wparams.set("version", parserToUse.getVersion());
        return wparams;
    }

    protected boolean isMultipart(Collection<ContentStream> streams) {
        boolean isMultipart = false;
        if (streams != null) {
            boolean hasNullStreamName = false;
            hasNullStreamName = streams.stream().anyMatch(cs -> cs.getName() == null);
            isMultipart = !hasNullStreamName && streams.size() > 1;
        }
        return isMultipart;
    }

    protected ModifiableSolrParams calculateQueryParams(Set<String> queryParamNames, ModifiableSolrParams wparams) {
        ModifiableSolrParams queryModParams = new ModifiableSolrParams();
        if (queryParamNames != null) {
            for (String param : queryParamNames) {
                String[] value = wparams.getParams(param);
                if (value == null) continue;
                for (String v : value) {
                    queryModParams.add(param, v);
                }
                wparams.remove(param);
            }
        }
        return queryModParams;
    }

    protected void validateGetRequest(SolrRequest<?> solrRequest) throws IOException {
        Collection<ContentStream> streams;
        RequestWriter.ContentWriter contentWriter = this.requestWriter.getContentWriter(solrRequest);
        Collection<ContentStream> collection = streams = contentWriter == null ? this.requestWriter.getContentStreams(solrRequest) : null;
        if (contentWriter != null || streams != null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "GET can't send streams!");
        }
    }

    protected abstract boolean isFollowRedirects();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NamedList<Object> processErrorsAndResponse(int httpStatus, String responseReason, String responseMethod, ResponseParser processor, InputStream is, String mimeType, String encoding, boolean isV2Api, String urlExceptionMessage) throws SolrServerException {
        Object error;
        NamedList<Object> rsp;
        boolean shouldClose = true;
        switch (httpStatus) {
            case 200: 
            case 400: 
            case 409: {
                break;
            }
            case 301: 
            case 302: {
                if (this.isFollowRedirects()) break;
                throw new SolrServerException("Server at " + urlExceptionMessage + " sent back a redirect (" + httpStatus + ").");
            }
            default: {
                if (processor != null && mimeType != null) break;
                throw new BaseHttpSolrClient.RemoteSolrException(urlExceptionMessage, httpStatus, "non ok status: " + httpStatus + ", message:" + responseReason, null);
            }
        }
        if (this.wantStream(processor)) {
            shouldClose = false;
            NamedList<Object> namedList = InputStreamResponseParser.createInputStreamNamedList(httpStatus, is);
            return namedList;
        }
        this.checkContentType(processor, is, mimeType, encoding, httpStatus, urlExceptionMessage);
        try {
            rsp = processor.processResponse(is, encoding);
        }
        catch (Exception e) {
            throw new BaseHttpSolrClient.RemoteSolrException(urlExceptionMessage, httpStatus, e.getMessage(), e);
        }
        Object object = error = rsp == null ? null : rsp.get("error");
        if (rsp != null && error == null && processor instanceof NoOpResponseParser) {
            error = rsp.get("response");
        }
        if (error != null && String.valueOf(Utils.getObjectByPath(error, true, errPath)).endsWith("ExceptionWithErrObject")) {
            throw BaseHttpSolrClient.RemoteExecutionException.create(urlExceptionMessage, rsp);
        }
        if (httpStatus != 200 && !isV2Api) {
            NamedList<String> metadata = null;
            String reason = null;
            try {
                if (error != null) {
                    Object metadataObj;
                    reason = (String)Utils.getObjectByPath(error, false, Collections.singletonList("msg"));
                    if (reason == null) {
                        reason = (String)Utils.getObjectByPath(error, false, Collections.singletonList("trace"));
                    }
                    if ((metadataObj = Utils.getObjectByPath(error, false, Collections.singletonList("metadata"))) instanceof NamedList) {
                        metadata = (NamedList<String>)metadataObj;
                    } else if (metadataObj instanceof List) {
                        List list = (List)metadataObj;
                        metadata = new NamedList(list.size() / 2);
                        for (int i = 0; i < list.size(); i += 2) {
                            metadata.add((String)list.get(i), (String)list.get(i + 1));
                        }
                    } else if (metadataObj instanceof Map) {
                        metadata = new NamedList<String>((Map)metadataObj);
                    }
                }
            }
            catch (Exception metadataObj) {
                // empty catch block
            }
            if (reason == null) {
                StringBuilder msg = new StringBuilder();
                msg.append(responseReason).append("\n").append("request: ").append(responseMethod);
                if (error != null) {
                    msg.append("\n\nError returned:\n").append(error);
                }
                reason = URLDecoder.decode(msg.toString(), FALLBACK_CHARSET);
            }
            BaseHttpSolrClient.RemoteSolrException rss = new BaseHttpSolrClient.RemoteSolrException(urlExceptionMessage, httpStatus, reason, null);
            if (metadata != null) {
                rss.setMetadata(metadata);
            }
            throw rss;
        }
        NamedList<Object> namedList = rsp;
        return namedList;
        finally {
            if (shouldClose) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected boolean wantStream(ResponseParser processor) {
        return processor == null || processor instanceof InputStreamResponseParser;
    }

    protected abstract boolean processorAcceptsMimeType(Collection<String> var1, String var2);

    protected abstract String allProcessorSupportedContentTypesCommaDelimited(Collection<String> var1);

    private void checkContentType(ResponseParser processor, InputStream is, String mimeType, String encoding, int httpStatus, String urlExceptionMessage) {
        boolean processorAcceptsMimeType;
        if (mimeType == null || processor == this.parser && this.defaultParserMimeTypes.contains(mimeType)) {
            return;
        }
        Collection<String> processorSupportedContentTypes = processor.getContentTypes();
        if (processorSupportedContentTypes != null && !processorSupportedContentTypes.isEmpty() && !(processorAcceptsMimeType = this.processorAcceptsMimeType(processorSupportedContentTypes, mimeType))) {
            String allSupportedTypes = this.allProcessorSupportedContentTypesCommaDelimited(processorSupportedContentTypes);
            String prefix = "Expected mime type in [" + allSupportedTypes + "] but got " + mimeType + ". ";
            String exceptionEncoding = encoding != null ? encoding : FALLBACK_CHARSET.name();
            try {
                ByteArrayOutputStream body = new ByteArrayOutputStream();
                is.transferTo(body);
                throw new BaseHttpSolrClient.RemoteSolrException(urlExceptionMessage, httpStatus, prefix + body.toString(exceptionEncoding), null);
            }
            catch (IOException e) {
                throw new BaseHttpSolrClient.RemoteSolrException(urlExceptionMessage, httpStatus, "Could not parse response with encoding " + exceptionEncoding, e);
            }
        }
    }

    protected static String basicAuthCredentialsToAuthorizationString(String user, String pass) {
        String userPass = user + ":" + pass;
        return "Basic " + Base64.getEncoder().encodeToString(userPass.getBytes(FALLBACK_CHARSET));
    }

    protected void setParser(ResponseParser parser) {
        this.parser = parser;
        this.updateDefaultMimeTypeForParser();
    }

    protected abstract void updateDefaultMimeTypeForParser();

    @Deprecated
    public abstract Cancellable asyncRequest(SolrRequest<?> var1, String var2, AsyncListener<NamedList<Object>> var3);

    public abstract CompletableFuture<NamedList<Object>> requestAsync(SolrRequest<?> var1, String var2);

    public CompletableFuture<NamedList<Object>> requestAsync(SolrRequest<?> request) {
        return this.requestAsync(request, null);
    }

    public boolean isV2ApiRequest(SolrRequest<?> request) {
        return request.getApiVersion() == SolrRequest.ApiVersion.V2;
    }

    public String getBaseURL() {
        return this.serverBaseUrl;
    }

    public ResponseParser getParser() {
        return this.parser;
    }

    public Set<String> getUrlParamNames() {
        return this.urlParamNames;
    }
}

