/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.util;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.apache.solr.common.SolrCloseable;
import org.apache.solr.common.util.MapBackedCache;

public class ObjectCache
extends MapBackedCache<String, Object>
implements SolrCloseable {
    private final AtomicBoolean isClosed = new AtomicBoolean(false);

    public ObjectCache() {
        super(new ConcurrentHashMap());
    }

    private void ensureNotClosed() {
        if (this.isClosed.get()) {
            throw new RuntimeException("This ObjectCache is already closed.");
        }
    }

    @Override
    public Object put(String key, Object val) {
        this.ensureNotClosed();
        return super.put(key, val);
    }

    @Override
    public Object get(String key) {
        this.ensureNotClosed();
        return super.get(key);
    }

    @Override
    public Object remove(String key) {
        this.ensureNotClosed();
        return super.remove(key);
    }

    @Override
    public void clear() {
        this.ensureNotClosed();
        super.clear();
    }

    public <T> T get(String key, Class<T> clazz) {
        Object o = this.get(key);
        if (o == null) {
            return null;
        }
        return clazz.cast(o);
    }

    public <T> T computeIfAbsent(String key, Class<T> clazz, Function<String, ? extends T> mappingFunction) {
        this.ensureNotClosed();
        T o = super.computeIfAbsent(key, mappingFunction);
        return clazz.cast(o);
    }

    @Override
    public boolean isClosed() {
        return this.isClosed.get();
    }

    @Override
    public void close() throws IOException {
        if (this.isClosed.compareAndSet(false, true)) {
            for (Object value : this.map.values()) {
                if (!(value instanceof Closeable)) continue;
                ((Closeable)value).close();
            }
            this.map.clear();
        }
    }
}

