"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.computeContinuousDataDomain = exports.computeDomainExtent = exports.computeOrdinalDataDomain = exports.constrainPadding = void 0;
var d3_array_1 = require("d3-array");
var constants_1 = require("../scales/constants");
var specs_1 = require("../specs");
function constrainPadding(start, end, newStart, newEnd, constrain) {
    if (constrain === void 0) { constrain = true; }
    if (constrain) {
        if (start < end) {
            return [start >= 0 && newStart < 0 ? 0 : newStart, end <= 0 && newEnd > 0 ? 0 : newEnd];
        }
        return [end >= 0 && newEnd < 0 ? 0 : newEnd, start <= 0 && newStart > 0 ? 0 : newStart];
    }
    return [newStart, newEnd];
}
exports.constrainPadding = constrainPadding;
function computeOrdinalDataDomain(data, accessor, sorted, removeNull) {
    if (data.length === 0) {
        return [0];
    }
    var domain = data.map(accessor).filter(function (d) { return (removeNull ? d !== null : true); });
    var uniqueValues = __spread(new Set(domain));
    return sorted ? uniqueValues.sort(function (a, b) { return ("" + a).localeCompare("" + b); }) : uniqueValues;
}
exports.computeOrdinalDataDomain = computeOrdinalDataDomain;
function getPaddedDomain(start, end, domainOptions) {
    if (!domainOptions || !domainOptions.padding || domainOptions.paddingUnit === specs_1.DomainPaddingUnit.Pixel) {
        return [start, end];
    }
    var padding = domainOptions.padding, _a = domainOptions.paddingUnit, paddingUnit = _a === void 0 ? specs_1.DomainPaddingUnit.Domain : _a;
    var absPadding = Math.abs(padding);
    var computedPadding = paddingUnit === specs_1.DomainPaddingUnit.Domain ? absPadding : absPadding * Math.abs(end - start);
    if (computedPadding === 0) {
        return [start, end];
    }
    var newStart = start - computedPadding;
    var newEnd = end + computedPadding;
    return constrainPadding(start, end, newStart, newEnd, domainOptions.constrainPadding);
}
function computeDomainExtent(domain, domainOptions) {
    if (domain[0] == null || domain[1] == null)
        return [0, 0];
    var inverted = domain[0] > domain[1];
    var paddedDomain = (function (_a) {
        var _b = __read(_a, 2), start = _b[0], end = _b[1];
        var _c = __read(getPaddedDomain(start, end, domainOptions), 2), paddedStart = _c[0], paddedEnd = _c[1];
        if (paddedStart >= 0 && paddedEnd >= 0) {
            return (domainOptions === null || domainOptions === void 0 ? void 0 : domainOptions.fit) ? [paddedStart, paddedEnd] : [0, paddedEnd];
        }
        if (paddedStart < 0 && paddedEnd < 0) {
            return (domainOptions === null || domainOptions === void 0 ? void 0 : domainOptions.fit) ? [paddedStart, paddedEnd] : [paddedStart, 0];
        }
        return [paddedStart, paddedEnd];
    })(inverted ? domain.slice().reverse() : domain);
    return inverted ? paddedDomain.slice().reverse() : paddedDomain;
}
exports.computeDomainExtent = computeDomainExtent;
function computeContinuousDataDomain(data, accessor, scaleType, domainOptions) {
    var _a, _b;
    var filteredData = (domainOptions === null || domainOptions === void 0 ? void 0 : domainOptions.fit) && scaleType === constants_1.ScaleType.Log ? data.filter(function (d) { return accessor(d) !== 0; }) : data;
    var range = d3_array_1.extent(filteredData, accessor);
    if (domainOptions === null) {
        return [(_a = range[0]) !== null && _a !== void 0 ? _a : 0, (_b = range[1]) !== null && _b !== void 0 ? _b : 0];
    }
    return computeDomainExtent(range, domainOptions);
}
exports.computeContinuousDataDomain = computeContinuousDataDomain;
//# sourceMappingURL=domain.js.map