/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathIOException;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.statistics.DurationTracker;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsBinding;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsStore;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.files.AbstractManifestData;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.files.FileEntry;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.files.TaskManifest;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.impl.AuditingIntegration;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.impl.ManifestStoreOperations;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.JobOrTaskStage;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.StageConfig;
import org.apache.hadoop.util.OperationDuration;
import org.apache.hadoop.util.Preconditions;
import org.apache.hadoop.util.functional.CallableRaisingIOE;
import org.apache.hadoop.util.functional.RemoteIterators;
import org.apache.hadoop.util.functional.TaskPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJobOrTaskStage<IN, OUT>
implements JobOrTaskStage<IN, OUT> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractJobOrTaskStage.class);
    public static final String FAILED_TO_RENAME_PREFIX = "Failed to ";
    private final boolean isTaskStage;
    private final StageConfig stageConfig;
    private final String stageStatisticName;
    private final ManifestStoreOperations operations;
    private final TaskPool.Submitter ioProcessors;
    private final AtomicBoolean executed = new AtomicBoolean(false);
    private DurationTracker stageExecutionTracker;
    private final String name;

    protected AbstractJobOrTaskStage(boolean isTaskStage, StageConfig stageConfig, String stageStatisticName, boolean requireIOProcessors) {
        String stageName;
        this.isTaskStage = isTaskStage;
        this.stageStatisticName = stageStatisticName;
        this.stageConfig = stageConfig;
        Objects.requireNonNull(stageConfig.getDestinationDir(), "Destination Directory");
        Objects.requireNonNull(stageConfig.getJobId(), "Job ID");
        Objects.requireNonNull(stageConfig.getJobAttemptDir(), "Job attempt directory");
        this.operations = Objects.requireNonNull(stageConfig.getOperations(), "Operations callbacks");
        this.ioProcessors = this.bindProcessor(requireIOProcessors, stageConfig.getIoProcessors());
        if (isTaskStage) {
            this.getRequiredTaskId();
            this.getRequiredTaskAttemptId();
            this.getRequiredTaskAttemptDir();
            stageName = String.format("[Task-Attempt %s]", this.getRequiredTaskAttemptId());
        } else {
            stageName = String.format("[Job-Attempt %s/%02d]", stageConfig.getJobId(), stageConfig.getJobAttemptNumber());
        }
        this.name = stageName;
    }

    private TaskPool.Submitter bindProcessor(boolean required, TaskPool.Submitter processor) {
        return required ? Objects.requireNonNull(processor, "required IO processor is null") : null;
    }

    @Override
    public final OUT apply(IN arguments) throws IOException {
        this.executeOnlyOnce();
        this.progress();
        String stageName = this.getStageName(arguments);
        this.getStageConfig().enterStage(stageName);
        String statisticName = this.getStageStatisticName(arguments);
        LOG.info("{}: Executing Stage {}", (Object)this.getName(), (Object)stageName);
        this.stageExecutionTracker = IOStatisticsBinding.createTracker(this.getIOStatistics(), statisticName);
        try {
            OUT out = this.executeStage(arguments);
            LOG.info("{}: Stage {} completed after {}", new Object[]{this.getName(), stageName, OperationDuration.humanTime(this.stageExecutionTracker.asDuration().toMillis())});
            OUT OUT = out;
            return OUT;
        }
        catch (IOException | RuntimeException e) {
            LOG.error("{}: Stage {} failed: after {}: {}", new Object[]{this.getName(), stageName, OperationDuration.humanTime(this.stageExecutionTracker.asDuration().toMillis()), e.toString()});
            LOG.debug("{}: Stage failure:", (Object)this.getName(), (Object)e);
            this.stageExecutionTracker.failed();
            throw e;
        }
        finally {
            this.stageExecutionTracker.close();
            this.progress();
            this.getStageConfig().exitStage(stageName);
        }
    }

    protected abstract OUT executeStage(IN var1) throws IOException;

    private void executeOnlyOnce() {
        Preconditions.checkState(!this.executed.getAndSet(true), "Stage attempted twice");
    }

    protected String getStageStatisticName(IN arguments) {
        return this.stageStatisticName;
    }

    protected String getStageName(IN arguments) {
        return this.getStageStatisticName(arguments);
    }

    public DurationTracker getStageExecutionTracker() {
        return this.stageExecutionTracker;
    }

    public void addExecutionDurationToStatistics(IOStatisticsStore iostats, String statistic) {
        iostats.addTimedOperation(statistic, this.getStageExecutionTracker().asDuration());
    }

    private void noteAnyRateLimiting(String statistic, Duration wait) {
        if (!wait.isZero()) {
            this.getIOStatistics().addTimedOperation(statistic, wait.toMillis());
        }
    }

    public ManifestStoreOperations getOperations() {
        return this.operations;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("AbstractJobOrTaskStage{");
        sb.append(this.isTaskStage ? "Task Stage" : "Job Stage");
        sb.append(" name='").append(this.name).append('\'');
        sb.append(" stage='").append(this.stageStatisticName).append('\'');
        sb.append('}');
        return sb.toString();
    }

    protected StageConfig getStageConfig() {
        return this.stageConfig;
    }

    protected void updateAuditContext(String stage) {
        AuditingIntegration.enterStageWorker(this.stageConfig.getJobId(), stage);
    }

    @Override
    public final IOStatisticsStore getIOStatistics() {
        return this.stageConfig.getIOStatistics();
    }

    protected final void progress() {
        if (this.stageConfig.getProgressable() != null) {
            this.stageConfig.getProgressable().progress();
        }
    }

    protected final FileStatus getFileStatusOrNull(Path path) throws IOException {
        try {
            return this.getFileStatus(path);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    protected final FileStatus getFileStatus(Path path) throws IOException {
        LOG.trace("{}: getFileStatus('{}')", (Object)this.getName(), (Object)path);
        Objects.requireNonNull(path, () -> String.format("%s: Null path for getFileStatus() call", this.getName()));
        return IOStatisticsBinding.trackDuration(this.getIOStatistics(), "op_get_file_status", () -> this.operations.getFileStatus(path));
    }

    protected final boolean isFile(Path path) throws IOException {
        LOG.trace("{}: isFile('{}')", (Object)this.getName(), (Object)path);
        return IOStatisticsBinding.trackDuration(this.getIOStatistics(), "op_is_file", () -> this.operations.isFile(path));
    }

    protected final boolean delete(Path path, boolean recursive) throws IOException {
        LOG.trace("{}: delete('{}, {}')", new Object[]{this.getName(), path, recursive});
        return this.delete(path, recursive, "op_delete");
    }

    protected Boolean delete(Path path, boolean recursive, String statistic) throws IOException {
        return IOStatisticsBinding.trackDuration(this.getIOStatistics(), statistic, () -> this.operations.delete(path, recursive));
    }

    protected final boolean mkdirs(Path path, boolean escalateFailure) throws IOException {
        LOG.trace("{}: mkdirs('{}')", (Object)this.getName(), (Object)path);
        return IOStatisticsBinding.trackDuration(this.getIOStatistics(), "op_mkdirs", () -> {
            boolean success = this.operations.mkdirs(path);
            if (!success && escalateFailure) {
                throw new PathIOException(path.toUri().toString(), this.stageStatisticName + ": mkdirs() returned false");
            }
            return success;
        });
    }

    protected final RemoteIterator<FileStatus> listStatusIterator(Path path) throws IOException {
        LOG.trace("{}: listStatusIterator('{}')", (Object)this.getName(), (Object)path);
        return IOStatisticsBinding.trackDuration(this.getIOStatistics(), "op_list_status", () -> this.operations.listStatusIterator(path));
    }

    protected final TaskManifest loadManifest(FileStatus status) throws IOException {
        LOG.trace("{}: loadManifest('{}')", (Object)this.getName(), (Object)status);
        return IOStatisticsBinding.trackDuration(this.getIOStatistics(), "op_load_manifest", () -> this.operations.loadTaskManifest(this.stageConfig.currentManifestSerializer(), status));
    }

    protected final RemoteIterator<FileStatus> listManifests() throws IOException {
        return RemoteIterators.filteringRemoteIterator(this.listStatusIterator(this.getTaskManifestDir()), st -> st.getPath().toUri().toString().endsWith("-manifest.json"));
    }

    protected final void msync(Path path) throws IOException {
        LOG.trace("{}: msync('{}')", (Object)this.getName(), (Object)path);
        IOStatisticsBinding.trackDurationOfInvocation(this.getIOStatistics(), "op_msync", () -> this.operations.msync(path));
    }

    protected final Path createNewDirectory(String operation, Path path) throws IOException {
        LOG.trace("{}: {} createNewDirectory('{}')", new Object[]{this.getName(), operation, path});
        Objects.requireNonNull(path, () -> String.format("%s: Null path for operation %s", this.getName(), operation));
        try {
            FileStatus status = this.getFileStatus(path);
            throw new FileAlreadyExistsException(operation + ": path " + path + " already exists and has status " + status);
        }
        catch (FileNotFoundException e) {
            this.mkdirs(path, true);
            return path;
        }
    }

    protected final Path directoryMustExist(String operation, Path path) throws IOException {
        FileStatus status = this.getFileStatus(path);
        if (!status.isDirectory()) {
            throw new PathIOException(path.toString(), operation + ": Path is not a directory; its status is :" + status);
        }
        return path;
    }

    protected final <T extends AbstractManifestData> void save(T manifestData, Path tempPath, Path finalPath) throws IOException {
        LOG.trace("{}: save('{}, {}, {}')", new Object[]{this.getName(), manifestData, tempPath, finalPath});
        IOStatisticsBinding.trackDurationOfInvocation(this.getIOStatistics(), "task_stage_save_task_manifest", () -> this.operations.save(manifestData, tempPath, true));
        this.renameFile(tempPath, finalPath);
    }

    public String getEtag(FileStatus status) {
        return this.operations.getEtag(status);
    }

    protected final void renameFile(Path source, Path dest) throws IOException {
        this.maybeDeleteDest(true, dest);
        this.executeRenamingOperation("renameFile", source, dest, "op_rename", () -> this.operations.renameFile(source, dest));
    }

    protected final void renameDir(Path source, Path dest) throws IOException {
        this.maybeDeleteDest(true, dest);
        this.executeRenamingOperation("renameDir", source, dest, "op_rename", () -> this.operations.renameDir(source, dest));
    }

    protected final CommitOutcome commitFile(FileEntry entry, boolean deleteDest) throws IOException {
        Path source = entry.getSourcePath();
        Path dest = entry.getDestPath();
        this.maybeDeleteDest(deleteDest, dest);
        if (this.storeSupportsResilientCommit()) {
            ManifestStoreOperations.CommitFileResult result = IOStatisticsBinding.trackDuration(this.getIOStatistics(), "commit_file_rename", () -> this.operations.commitFile(entry));
            if (result.recovered()) {
                this.getIOStatistics().incrementCounter("commit_file_rename_recovered");
            }
            if (result.getWaitTime() != null) {
                this.noteAnyRateLimiting("store_io_rate_limited", result.getWaitTime());
            }
        } else {
            this.executeRenamingOperation("renameFile", source, dest, "commit_file_rename", () -> this.operations.renameFile(source, dest));
        }
        return new CommitOutcome();
    }

    protected boolean storeSupportsResilientCommit() {
        return this.operations.storeSupportsResilientCommit();
    }

    private void maybeDeleteDest(boolean deleteDest, Path dest) throws IOException {
        if (deleteDest && this.getFileStatusOrNull(dest) != null) {
            boolean deleted = this.delete(dest, true);
            LOG.debug("{}: delete('{}') returned {}'", new Object[]{this.getName(), dest, deleted});
        }
    }

    private void executeRenamingOperation(String operation, Path source, Path dest, String statistic, CallableRaisingIOE<Boolean> action) throws IOException {
        boolean success;
        LOG.debug("{}: {} '{}' to '{}')", new Object[]{this.getName(), operation, source, dest});
        Objects.requireNonNull(source, "Null source");
        Objects.requireNonNull(dest, "Null dest");
        try (DurationTracker tracker = IOStatisticsBinding.createTracker(this.getIOStatistics(), statistic);){
            success = action.apply();
            if (!success) {
                tracker.failed();
            }
        }
        if (!success) {
            throw this.escalateRenameFailure(operation, source, dest);
        }
    }

    private PathIOException escalateRenameFailure(String operation, Path source, Path dest) throws IOException {
        FileStatus sourceStatus = this.getFileStatus(source);
        FileStatus destStatus = this.getFileStatusOrNull(dest);
        LOG.error("{}: failure to {} {} to {} with source status {}  and destination status {}", new Object[]{this.getName(), operation, source, dest, sourceStatus, destStatus});
        return new PathIOException(source.toString(), FAILED_TO_RENAME_PREFIX + operation + " to " + dest);
    }

    protected final String getJobId() {
        return this.stageConfig.getJobId();
    }

    protected final int getJobAttemptNumber() {
        return this.stageConfig.getJobAttemptNumber();
    }

    protected final String getTaskId() {
        return this.stageConfig.getTaskId();
    }

    protected final String getRequiredTaskId() {
        return Objects.requireNonNull(this.getTaskId(), "No Task ID in stage config");
    }

    protected final String getTaskAttemptId() {
        return this.stageConfig.getTaskAttemptId();
    }

    protected final String getRequiredTaskAttemptId() {
        return Objects.requireNonNull(this.getTaskAttemptId(), "No Task Attempt ID in stage config");
    }

    protected final Path getJobAttemptDir() {
        return this.stageConfig.getJobAttemptDir();
    }

    protected final Path getTaskManifestDir() {
        return this.stageConfig.getTaskManifestDir();
    }

    protected final Path getTaskAttemptDir() {
        return this.stageConfig.getTaskAttemptDir();
    }

    protected final Path getRequiredTaskAttemptDir() {
        return Objects.requireNonNull(this.getTaskAttemptDir(), "No Task Attempt Dir");
    }

    protected final Path getDestinationDir() {
        return this.stageConfig.getDestinationDir();
    }

    public final String getName() {
        return this.name;
    }

    protected final TaskPool.Submitter getIOProcessors() {
        return this.ioProcessors;
    }

    protected final TaskPool.Submitter getIOProcessors(int size) {
        return size > 1 ? this.getIOProcessors() : null;
    }

    protected IOException deleteDir(Path dir, Boolean suppressExceptions) throws IOException {
        try {
            this.delete(dir, true);
            return null;
        }
        catch (IOException ex) {
            LOG.info("Error deleting {}: {}", (Object)dir, (Object)ex.toString());
            if (!suppressExceptions.booleanValue()) {
                throw ex;
            }
            return ex;
        }
    }

    protected FileEntry fileEntry(FileStatus status, Path destDir) {
        Path dest = new Path(destDir, status.getPath().getName());
        return new FileEntry(status.getPath(), dest, status.getLen(), this.getEtag(status));
    }

    public static final class CommitOutcome {
    }
}

