/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.asymmetric;

import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.AsymmetricPublicKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricXDHKey;
import org.bouncycastle.crypto.asymmetric.KeyUtils;
import org.bouncycastle.crypto.general.EdEC;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;

public final class AsymmetricXDHPublicKey
extends AsymmetricXDHKey
implements AsymmetricPublicKey {
    static final byte[] x448Prefix = Hex.decode("3042300506032b656f033900");
    static final byte[] x25519Prefix = Hex.decode("302a300506032b656e032100");
    private static final byte x448_type = 111;
    private static final byte x25519_type = 110;
    private final byte[] keyData;
    private final int hashCode;

    public AsymmetricXDHPublicKey(Algorithm algorithm, byte[] byArray) {
        super(algorithm);
        this.keyData = Arrays.clone(byArray);
        this.hashCode = this.calculateHashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AsymmetricXDHPublicKey(byte[] byArray) {
        super(byArray[8] == 111 ? EdEC.Algorithm.X448 : EdEC.Algorithm.X25519);
        if (byArray[8] == 111) {
            if (!KeyUtils.isValidPrefix(x448Prefix, byArray) || byArray.length - x448Prefix.length != 56) throw new IllegalArgumentException("raw key data not recognised");
            this.keyData = Arrays.copyOfRange(byArray, x448Prefix.length, byArray.length);
        } else {
            if (!KeyUtils.isValidPrefix(x25519Prefix, byArray) || byArray.length - x25519Prefix.length != 32) throw new IllegalArgumentException("raw key data not recognised");
            this.keyData = Arrays.copyOfRange(byArray, x25519Prefix.length, byArray.length);
        }
        this.hashCode = this.calculateHashCode();
    }

    public byte[] getPublicData() {
        return Arrays.clone(this.keyData);
    }

    @Override
    public byte[] getEncoded() {
        if (this.getAlgorithm().equals(EdEC.Algorithm.X448)) {
            byte[] byArray = new byte[x448Prefix.length + this.keyData.length];
            System.arraycopy(x448Prefix, 0, byArray, 0, x448Prefix.length);
            System.arraycopy(this.keyData, 0, byArray, x448Prefix.length, this.keyData.length);
            return byArray;
        }
        byte[] byArray = new byte[x25519Prefix.length + this.keyData.length];
        System.arraycopy(x25519Prefix, 0, byArray, 0, x25519Prefix.length);
        System.arraycopy(this.keyData, 0, byArray, x25519Prefix.length, this.keyData.length);
        return byArray;
    }

    @Override
    public boolean equals(Object object) {
        this.checkApprovedOnlyModeStatus();
        if (this == object) {
            return true;
        }
        if (!(object instanceof AsymmetricXDHPublicKey)) {
            return false;
        }
        AsymmetricXDHPublicKey asymmetricXDHPublicKey = (AsymmetricXDHPublicKey)object;
        if (!Arrays.areEqual(this.keyData, asymmetricXDHPublicKey.keyData)) {
            return false;
        }
        return this.getAlgorithm().equals(asymmetricXDHPublicKey.getAlgorithm());
    }

    @Override
    public int hashCode() {
        this.checkApprovedOnlyModeStatus();
        return this.hashCode;
    }

    private int calculateHashCode() {
        int n = this.getAlgorithm().hashCode();
        n = 31 * n + Arrays.hashCode(this.keyData);
        return n;
    }
}

