/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.discovery.util;

import org.eclipse.equinox.internal.p2.ui.discovery.DiscoveryUi;
import org.eclipse.equinox.internal.p2.ui.discovery.util.CommonColors;
import org.eclipse.equinox.internal.p2.ui.discovery.util.GradientCanvas;
import org.eclipse.jface.window.ToolTip;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;

public abstract class GradientToolTip
extends ToolTip {
    private CommonColors colors;

    public GradientToolTip(Control control, int style, boolean manualActivation) {
        super(control, style, manualActivation);
        this.initResources(control);
    }

    public GradientToolTip(Control control) {
        super(control);
        this.initResources(control);
    }

    private void initResources(Control control) {
        this.colors = DiscoveryUi.getCommonsColors();
    }

    protected final Composite createToolTipContentArea(Event event, Composite parent) {
        GradientCanvas gradient = new GradientCanvas(parent, 0);
        gradient.setSeparatorVisible(false);
        GridLayout headLayout = new GridLayout();
        headLayout.marginHeight = 0;
        headLayout.marginWidth = 0;
        headLayout.horizontalSpacing = 0;
        headLayout.verticalSpacing = 0;
        headLayout.numColumns = 1;
        gradient.setLayout((Layout)headLayout);
        gradient.setBackgroundGradient(new Color[]{this.colors.getGradientBegin(), this.colors.getGradientEnd()}, new int[]{100}, true);
        this.createToolTipArea(event, (Composite)gradient);
        Control[] controlArray = gradient.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            this.setNullBackground(c);
            ++n2;
        }
        return gradient;
    }

    private void setNullBackground(Control outerCircle) {
        outerCircle.setBackground(null);
        if (outerCircle instanceof Composite) {
            ((Composite)outerCircle).setBackgroundMode(2);
            Control[] controlArray = ((Composite)outerCircle).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                this.setNullBackground(c);
                ++n2;
            }
        }
    }

    protected abstract Composite createToolTipArea(Event var1, Composite var2);
}

