/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.protocol;

import generic.lsh.vector.LSHVectorFactory;
import ghidra.features.bsim.query.LSHException;
import ghidra.features.bsim.query.protocol.BSimQuery;
import ghidra.features.bsim.query.protocol.ResponseVectorId;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlPullParser;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class QueryVectorId
extends BSimQuery<ResponseVectorId> {
    public List<Long> vectorIds = new ArrayList<Long>();
    public ResponseVectorId vectorIdResponse;

    public QueryVectorId() {
        super("queryvectorid");
    }

    @Override
    public void buildResponseTemplate() {
        if (this.response == null) {
            this.vectorIdResponse = new ResponseVectorId();
            this.response = this.vectorIdResponse;
        }
    }

    @Override
    public void saveXml(Writer fwrite) throws IOException {
        fwrite.append('<').append(this.name).append(">\n");
        for (Long id : this.vectorIds) {
            fwrite.append("  <id>0x");
            fwrite.append(Long.toHexString(id));
            fwrite.append("</id>\n");
        }
        fwrite.append("</").append(this.name).append(">\n");
    }

    @Override
    public void restoreXml(XmlPullParser parser, LSHVectorFactory vectorFactory) throws LSHException {
        parser.start(new String[0]);
        while (parser.peek().isStart()) {
            parser.start(new String[0]);
            long val = SpecXmlUtils.decodeLong((String)parser.end().getText());
            this.vectorIds.add(val);
        }
        parser.end();
    }
}

