/*
 * Decompiled with CFR 0.152.
 */
package ghidra.sleigh.grammar;

import ghidra.sleigh.grammar.Location;
import java.util.SortedMap;
import java.util.TreeMap;

public class Locator {
    private TreeMap<Integer, Location> map = new TreeMap();

    public void registerLocation(int expandedLineNo, Location realLocation) {
        this.map.put(expandedLineNo, realLocation);
    }

    public Location getLocation(int expandedLineNo) {
        SortedMap<Integer, Location> headMap = this.map.headMap(expandedLineNo + 1);
        if (headMap.size() == 0) {
            return null;
        }
        Integer key = headMap.lastKey();
        Location location = (Location)headMap.get(key);
        int actualLineNumber = expandedLineNo - key + location.lineno;
        Location correctLocation = new Location(location.filename, actualLineNumber);
        return correctLocation;
    }
}

