/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework;

import ghidra.framework.ShutdownPriority;
import java.util.TreeSet;

public class ShutdownHookRegistry {
    private static boolean hookInstalled = false;
    private static TreeSet<ShutdownHook> hooks = new TreeSet();

    public static synchronized ShutdownHook addShutdownHook(Runnable r, ShutdownPriority priority) {
        ShutdownHook hook = new ShutdownHook(r, priority.getPriority());
        hooks.add(hook);
        ShutdownHookRegistry.installHook();
        return hook;
    }

    public static synchronized void removeShutdownHook(ShutdownHook hook) {
        hooks.remove(hook);
    }

    private static void installHook() {
        if (hookInstalled) {
            return;
        }
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                ShutdownHookRegistry.notifyHooks();
            }
        }, "Shutdown Hook Registry Notifier"));
        hookInstalled = true;
    }

    private static void notifyHooks() {
        for (ShutdownHook hook : hooks) {
            try {
                hook.r.run();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public static class ShutdownHook
    implements Comparable<ShutdownHook> {
        Runnable r;
        int priority;

        ShutdownHook(Runnable r, int priority) {
            this.r = r;
            this.priority = priority;
        }

        @Override
        public int compareTo(ShutdownHook o) {
            return this.priority - o.priority;
        }
    }
}

