/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.swt;

import ca.odell.glazedlists.impl.beans.BeanProperty;
import ca.odell.glazedlists.swt.DefaultItemFormat;
import ca.odell.glazedlists.swt.ItemFormat;

public final class BeanItemFormat<E>
implements ItemFormat<E> {
    private String propertyName = null;
    private BeanProperty<E> beanProperty;
    private ItemFormat delegateItemFormat;

    public BeanItemFormat(String propertyName) {
        this(propertyName, "");
    }

    public BeanItemFormat(String propertyName, String valueForNullElement) {
        this.propertyName = propertyName;
        this.delegateItemFormat = new DefaultItemFormat(valueForNullElement);
    }

    @Override
    public String format(E element) {
        if (element == null) {
            return this.delegateItemFormat.format(element);
        }
        if (this.beanProperty == null) {
            this.loadPropertyDescriptors(element);
        }
        Object property = this.beanProperty.get(element);
        return this.delegateItemFormat.format(property);
    }

    private void loadPropertyDescriptors(E beanObject) {
        Class<?> beanClass = beanObject.getClass();
        this.beanProperty = new BeanProperty(beanClass, this.propertyName, true, false);
    }
}

