/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.oat.oatmethod;

import ghidra.app.util.bin.BinaryReader;
import ghidra.file.formats.android.oat.oatmethod.OatMethodOffsets;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Structure;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class OatMethodOffsets_KitKat
extends OatMethodOffsets {
    private int frame_size_in_bytes_;
    private int core_spill_mask_;
    private int fp_spill_mask_;
    private int mapping_table_offset_;
    private int vmap_table_offset_;
    private int gc_map_offset_;

    public OatMethodOffsets_KitKat(BinaryReader reader) throws IOException {
        super(reader);
        this.frame_size_in_bytes_ = reader.readNextInt();
        this.core_spill_mask_ = reader.readNextInt();
        this.fp_spill_mask_ = reader.readNextInt();
        this.mapping_table_offset_ = reader.readNextInt();
        this.vmap_table_offset_ = reader.readNextInt();
        this.gc_map_offset_ = reader.readNextInt();
    }

    public int getFrameSizeInBytes() {
        return this.frame_size_in_bytes_;
    }

    public int getCoreSpillMask() {
        return this.core_spill_mask_;
    }

    public int getFpSpillMask() {
        return this.fp_spill_mask_;
    }

    public int getMappingTableOffset() {
        return this.mapping_table_offset_;
    }

    public int getVmapTableOffset() {
        return this.vmap_table_offset_;
    }

    public int getGcMapOffset() {
        return this.gc_map_offset_;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        Structure structure = (Structure)super.toDataType();
        structure.add(DWORD, "frame_size_in_bytes_", null);
        structure.add(DWORD, "core_spill_mask_", null);
        structure.add(DWORD, "fp_spill_mask_", null);
        structure.add(DWORD, "mapping_table_offset_", null);
        structure.add(DWORD, "vmap_table_offset_", null);
        structure.add(DWORD, "gc_map_offset_", null);
        structure.add(DWORD, "gc_map_offset_", null);
        structure.setCategoryPath(new CategoryPath("/oat"));
        return structure;
    }
}

