/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ext4;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class Ext4ExtentIdx
implements StructConverter {
    private int ei_block;
    private int ei_leaf_lo;
    private short ei_leaf_hi;
    private short ei_unused;

    public Ext4ExtentIdx(ByteProvider provider) throws IOException {
        this(new BinaryReader(provider, true));
    }

    public Ext4ExtentIdx(BinaryReader reader) throws IOException {
        this.ei_block = reader.readNextInt();
        this.ei_leaf_lo = reader.readNextInt();
        this.ei_leaf_hi = reader.readNextShort();
        this.ei_unused = reader.readNextShort();
    }

    public int getEi_block() {
        return this.ei_block;
    }

    public int getEi_leaf_lo() {
        return this.ei_leaf_lo;
    }

    public short getEi_leaf_hi() {
        return this.ei_leaf_hi;
    }

    public long getEi_leaf() {
        return Short.toUnsignedLong(this.ei_leaf_hi) << 32 | Integer.toUnsignedLong(this.ei_leaf_lo);
    }

    public short getEi_unused() {
        return this.ei_unused;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType structure = new StructureDataType("ext4_extent_idx", 0);
        structure.add(DWORD, "ei_block", null);
        structure.add(DWORD, "ei_leaf_lo", null);
        structure.add(WORD, "ei_leaf_hi", null);
        structure.add(WORD, "ei_unused", null);
        return structure;
    }
}

