/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ios.apple8900;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.file.crypto.DecryptedPacket;
import ghidra.file.crypto.Decryptor;
import ghidra.file.formats.ios.apple8900.Apple8900Constants;
import ghidra.file.formats.ios.apple8900.Apple8900Header;
import ghidra.file.formats.ios.generic.iOS_AesCrypto;
import ghidra.util.exception.CryptoException;
import ghidra.util.task.TaskMonitor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;

public class Apple8900Decryptor
implements Decryptor {
    @Override
    public boolean isValid(ByteProvider provider) throws IOException {
        byte[] bytes = provider.readBytes(0L, 4L);
        return Arrays.equals(bytes, Apple8900Constants.MAGIC_BYTES);
    }

    @Override
    public DecryptedPacket decrypt(String firmwareName, String firmwarePath, ByteProvider provider, TaskMonitor monitor) throws IOException, CryptoException {
        BinaryReader reader = new BinaryReader(provider, true);
        Apple8900Header header = new Apple8900Header(reader);
        if (!header.getMagic().equals("8900")) {
            throw new IOException("The 8900 file is not valid!");
        }
        byte[] encryptedBlock = reader.readNextByteArray(header.getSizeOfData());
        if (header.isEncrypted()) {
            iOS_AesCrypto crypto = new iOS_AesCrypto(Apple8900Constants.AES_KEY_BYTES, Apple8900Constants.AES_IV_ZERO_BYTES);
            byte[] decryptedBlock = crypto.decrypt(encryptedBlock);
            return new DecryptedPacket(new ByteArrayInputStream(decryptedBlock), decryptedBlock.length);
        }
        return new DecryptedPacket(new ByteArrayInputStream(encryptedBlock), encryptedBlock.length);
    }
}

