/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.actions;

import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.support.GTreeFilter;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.actions.FindDataTypesBySizeAction;
import ghidra.app.plugin.core.datamgr.tree.DataTypeNode;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Structure;
import ghidra.util.HelpLocation;
import ghidra.util.datastruct.Range;
import ghidra.util.datastruct.SortedRangeList;

public class FindStructuresBySizeAction
extends FindDataTypesBySizeAction {
    public static final String NAME = "Find Structures by Size";

    public FindStructuresBySizeAction(DataTypeManagerPlugin plugin, String menuSubGroup) {
        super(plugin, NAME, menuSubGroup);
        this.setHelpLocation(new HelpLocation("DataTypeManagerPlugin", "Find_Structures_By_Size"));
    }

    @Override
    protected GTreeFilter createFilter(SortedRangeList values) {
        return new StructureSizeGTreeFilter(this, values);
    }

    private class StructureSizeGTreeFilter
    implements GTreeFilter {
        private final SortedRangeList sizes;

        StructureSizeGTreeFilter(FindStructuresBySizeAction findStructuresBySizeAction, SortedRangeList sizes) {
            this.sizes = sizes;
        }

        public boolean showFilterMatches() {
            return true;
        }

        public boolean acceptsNode(GTreeNode node) {
            if (!(node instanceof DataTypeNode)) {
                return false;
            }
            DataTypeNode dataTypeNode = (DataTypeNode)node;
            DataType dataType = dataTypeNode.getDataType();
            if (!(dataType instanceof Structure)) {
                return false;
            }
            Structure structure = (Structure)dataType;
            int length = structure.getLength();
            if (structure.isZeroLength()) {
                length = 0;
            }
            for (Range range : this.sizes) {
                if (!range.contains(length)) continue;
                return true;
            }
            return false;
        }
    }
}

