/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.sourcefilestable;

import docking.widgets.table.AbstractDynamicTableColumn;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.TableColumnDescriptor;
import docking.widgets.table.threaded.ThreadedTableModelStub;
import ghidra.app.plugin.core.sourcefilestable.SourceFilesTablePlugin;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.database.sourcemap.UserDataPathTransformer;
import ghidra.program.model.listing.Program;
import ghidra.program.model.sourcemap.SourcePathTransformRecord;
import ghidra.program.model.sourcemap.SourcePathTransformer;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;

public class TransformerTableModel
extends ThreadedTableModelStub<SourcePathTransformRecord> {
    private SourceFilesTablePlugin plugin;
    private Program program;
    private SourcePathTransformer pathTransformer;

    public TransformerTableModel(SourceFilesTablePlugin plugin) {
        super("Transformer Table Model", (ServiceProvider)plugin.getTool());
        this.plugin = plugin;
        this.program = plugin.getCurrentProgram();
        if (this.program != null) {
            this.pathTransformer = UserDataPathTransformer.getPathTransformer((Program)this.program);
        }
    }

    protected Program getProgram() {
        return this.program;
    }

    protected void doLoad(Accumulator<SourcePathTransformRecord> accumulator, TaskMonitor monitor) throws CancelledException {
        if (this.pathTransformer == null) {
            return;
        }
        for (SourcePathTransformRecord transformRecord : this.pathTransformer.getTransformRecords()) {
            accumulator.add((Object)transformRecord);
        }
    }

    protected TableColumnDescriptor<SourcePathTransformRecord> createTableColumnDescriptor() {
        TableColumnDescriptor descriptor = new TableColumnDescriptor();
        descriptor.addVisibleColumn((DynamicTableColumn)new SourceColumn(this));
        descriptor.addVisibleColumn((DynamicTableColumn)new TargetColumn(this));
        descriptor.addVisibleColumn((DynamicTableColumn)new IsDirectoryTransformColumn(this));
        return descriptor;
    }

    protected void reloadProgram(Program newProgram) {
        this.program = newProgram;
        this.pathTransformer = this.program == null ? null : UserDataPathTransformer.getPathTransformer((Program)this.plugin.getCurrentProgram());
        this.reload();
    }

    private class SourceColumn
    extends AbstractDynamicTableColumn<SourcePathTransformRecord, String, Object> {
        private SourceColumn(TransformerTableModel transformerTableModel) {
        }

        public String getColumnName() {
            return "Source";
        }

        public String getValue(SourcePathTransformRecord rowObject, Settings settings, Object data, ServiceProvider services) throws IllegalArgumentException {
            if (rowObject.isDirectoryTransform()) {
                return rowObject.source();
            }
            return rowObject.sourceFile().toString();
        }
    }

    private class TargetColumn
    extends AbstractDynamicTableColumn<SourcePathTransformRecord, String, Object> {
        private TargetColumn(TransformerTableModel transformerTableModel) {
        }

        public String getColumnName() {
            return "Target";
        }

        public String getValue(SourcePathTransformRecord rowObject, Settings settings, Object data, ServiceProvider services) throws IllegalArgumentException {
            return rowObject.target();
        }
    }

    private class IsDirectoryTransformColumn
    extends AbstractDynamicTableColumn<SourcePathTransformRecord, Boolean, Object> {
        private IsDirectoryTransformColumn(TransformerTableModel transformerTableModel) {
        }

        public String getColumnName() {
            return "Directory Transform";
        }

        public Boolean getValue(SourcePathTransformRecord rowObject, Settings settings, Object data, ServiceProvider services) throws IllegalArgumentException {
            return rowObject.isDirectoryTransform();
        }
    }
}

