/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.debug;

import ghidra.app.util.bin.BinaryReader;
import java.io.IOException;
import java.util.ArrayList;

public class OMFLibrary {
    private String[] libs;

    OMFLibrary(BinaryReader reader, int ptr, int numBytes) throws IOException {
        ArrayList<String> libList = new ArrayList<String>();
        while (numBytes > 0) {
            byte len = reader.readByte(ptr);
            --numBytes;
            int length = Byte.toUnsignedInt(len);
            String lib = reader.readAsciiString(++ptr, length);
            ptr += length;
            numBytes -= length;
            libList.add(lib);
        }
        this.libs = new String[libList.size()];
        libList.toArray(this.libs);
    }

    public String[] getLibraries() {
        return this.libs;
    }
}

